<?php 
include('header.php');

// Ensure only admins can access
if (checkAdmin($udata['type'])) {

    // Delete user
    if (isset($_GET['deleteuser']) && $_GET['deleteuser'] == 1 && !empty($_GET['id'])) {
        $id = base64_decode(mysqli_real_escape_string($tng_conn, $_GET['id']));
        if (mysqli_query($tng_conn, "DELETE FROM users WHERE id='$id'")) {
            showAlert('User Deleted Successfully');
            ahkRedirect('users.php', 1200);
        }
    }

    // Ban user
    if (isset($_GET['banid']) && isset($_GET['ban']) && $_GET['ban'] == '1') {
        $banid = base64_decode(getSafe($_GET['banid']));
        if (ahkQuery("UPDATE users SET status='0' WHERE id='$banid'")) {
            showAlert('User Banned Successfully');
            ahkRedirect('users.php', 1200);
        }
    }

    // Approve user
    if (isset($_GET['apid']) && isset($_GET['approve']) && $_GET['approve'] == '1') {
        $apid = base64_decode(getSafe($_GET['apid']));
        if (ahkQuery("UPDATE users SET status='1' WHERE id='$apid'")) {
            showAlert('User Activated Successfully');
            ahkRedirect('users.php', 1200);
        }
    }

} else {
    header("Location: index.php");
    exit;
}
?>
<!--start page wrapper -->
<div class="page-wrapper">
    <div class="page-content">
        <div class="card radius-10">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div>
                        <h5 class="mb-0">All Users List</h5>
                    </div>
                </div>
                <hr>
                <div class="table-responsive">
                    <table id="example2" class="table align-middle mb-0">
                        <thead class="table-light">
                            <tr>
                                <th class="text-center">SL.</th>
                                <th class="text-center">Username</th>
                                <th class="text-center">Name</th>
                                <th class="text-center">Email</th>
                                <th class="text-center">Type</th>
                                <th class="text-center">Balance</th>
                                <th class="text-center">Action</th>
                            </tr>
                        </thead>
                        <tbody>
<?php
$res = mysqli_query($tng_conn,"SELECT * FROM users ORDER BY id DESC");
if (mysqli_num_rows($res) > 0) {
    $x = 0;
    while ($data = mysqli_fetch_assoc($res)) {
        if ($data['type'] == 'admin') {
            continue;
        }
        $x++;
        ?>
        <tr>
            <td class="text-center"><?= $x; ?></td>
            <td class="text-center"><?= htmlspecialchars($data['phone']); ?></td>
            <td class="text-center"><?= htmlspecialchars($data['name']); ?></td>
            <td class="text-center"><?= htmlspecialchars($data['email']); ?></td>
            <td class="text-center">
                <div class="ms-2">
                    <h6 class="mb-1 font-14"><?= strtoupper($data['type']); ?></h6>
                </div>
            </td>
            <td class="text-center">
                <?= ($data['balance'] !== null ? htmlspecialchars($data['balance']) : "0.00"); ?>
                <form action="BalanceTransfer.php" method="POST">
                    <input type="hidden" name="username" value="<?= htmlspecialchars($data['email']); ?>">
                    <button class="btn btn-success" type="submit">Balance Transfer</button>
                </form>
            </td>
            <td class="text-center">
                <div class="mr-12 font-24">
                    <a class="text-success bg-light-success" title="Login As User" 
                       href="users.php?phone=<?= base64_encode($data['phone']); ?>&login=1">
                       <img height="50px" src="../template/tngweb/assets/login-rounded-right.png">
                    </a>
                    <a class="text-success bg-light-success" title="Reset Password" 
                       href="users.php?id=<?= base64_encode($data['id']); ?>&reset=1">
                       <i class='bx bx-refresh'></i>
                    </a>
                    <a class="text-success bg-light-success" 
                       href="EditUser.php?id=<?= base64_encode($data['id']); ?>">
                       <i class='bx bx-pencil'></i>
                    </a>
                    <?php if ($data['status'] == '0') { ?>
                        <a class="text-success bg-light-success" title="Approve User" 
                           href="?apid=<?= base64_encode($data['id']); ?>&approve=1">
                           <i class='bx bx-check'></i>
                        </a>
                    <?php } else { ?>
                        <a class="text-danger bg-light-danger" title="Ban User" 
                           href="?banid=<?= base64_encode($data['id']); ?>&ban=1">
                           <i class='bx bx-x'></i>
                        </a>
                    <?php } ?>
                    <a class="text-danger bg-light-danger" 
                       href="?deleteuser=1&id=<?= base64_encode($data['id']); ?>">
                       <i class='bx bx-trash'></i>
                    </a>
                </div>
            </td>
        </tr>
        <?php
    }
}
?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<!--end page wrapper -->
<?php include('footer.php'); ?>
