<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/tngweb/header.php');

if(isset($_POST['curpass']) && !empty($_POST['cpass']) && !empty($_POST['npass'])) {
    $result = change_password($tng_conn, $_SESSION['phone'], $_POST['curpass'], $_POST['npass'], $_POST['cpass']);
    ?>
    <script>
        $(function(){
            Swal.fire(
                '<?php echo $result['title']; ?>',
                '<?php echo $result['text']; ?>',
                '<?php echo $result['status'] ? 'success' : 'error'; ?>'
            )
        });
    </script>
    <?php
}


if(isset($_POST['phone'], $_POST['email'], $_POST['name'], $_POST['address'], $_POST['otp_system'])) {
    $result = update_profile($tng_conn, $_POST);
    ?>
    <script>
        $(function(){
            Swal.fire(
                '<?php echo $result['title']; ?>',
                '<?php echo $result['text']; ?>',
                '<?php echo $result['status'] ? 'success' : 'error'; ?>'
            )
        });
        <?php if(!empty($result['redirect'])) { ?>
        setTimeout(() => {
            window.location.href='';
        }, 1200);
        <?php } ?>
    </script>
    <?php
}
?>


<!--start page wrapper -->
<div class="page-wrapper">
  <div class="page-content">
    <div class="row">
         <!-- Back Button -->
        <div class="d-flex align-items-center justify-content-between mb-3">
          <a href="javascript:void(0);" onclick="window.history.back();" class="btn btn-outline-primary rounded-pill px-4 py-2 fw-semibold">
            <i class="bi bi-arrow-left-circle me-2"></i> Go Back
          </a>
          <h5 class="mb-0 fw-bold text-primary">💰 Profile</h5>
        </div>
      <!-- Profile Card -->
      <div class="col-lg-4">
        <div class="card radius-15 shadow-lg border-0">
          <div class="card-body text-center">
            <img src="<?php echo XyZ_val('logo'); ?>" alt="Profile" class="rounded-circle p-1 bg-primary" width="110">
            <h4 class="mt-3"><?php echo $udata['name']; ?></h4>
            <p class="text-secondary mb-1"><?php echo XyZ_val('brand'); ?></p>
            <p class="text-muted font-size-sm">THE INDIA'S BEST <?php echo XyZ_val('brand').' '.XyZ_val('title'); ?></p>
            <hr class="my-4" />
            <ul class="list-group list-group-flush text-start">
              <li class="list-group-item d-flex justify-content-between align-items-center">
                <i class="bi bi-globe me-2"></i>Website
                <span class="text-secondary"><?php echo $domain; ?></span>
              </li>
              <li class="list-group-item d-flex justify-content-between align-items-center">
                <i class="bi bi-github me-2"></i>Github
                <span class="text-secondary"><?php echo XyZ_val('brand'); ?></span>
              </li>
              <li class="list-group-item d-flex justify-content-between align-items-center">
                <i class="bi bi-twitter me-2 text-info"></i>Twitter
                <span class="text-secondary">@<?php echo XyZ_val('brand'); ?></span>
              </li>
              <li class="list-group-item d-flex justify-content-between align-items-center">
                <i class="bi bi-instagram me-2 text-danger"></i>Instagram
                <span class="text-secondary"><?php echo XyZ_val('brand'); ?></span>
              </li>
              <li class="list-group-item d-flex justify-content-between align-items-center">
                <i class="bi bi-facebook me-2 text-primary"></i>Facebook
                <span class="text-secondary"><?php echo XyZ_val('brand'); ?></span>
              </li>
            </ul>
          </div>
        </div>
      </div>

      <!-- Profile Form -->
      <div class="col-lg-8">
        <form action="" method="POST">
          <div class="card radius-15 shadow-lg border-0">
            <div class="card-body">
              <h5 class="mb-4 text-primary fw-bold">Edit Profile</h5>

              <div class="row mb-3">
                <label class="col-sm-3 col-form-label">Full Name</label>
                <div class="col-sm-9">
                  <input name="name" type="text" class="form-control" value="<?php echo $udata['name']; ?>" required>
                </div>
              </div>

              <div class="row mb-3">
                <label class="col-sm-3 col-form-label">Email</label>
                <div class="col-sm-9">
                  <input name="email" type="email" class="form-control" value="<?php echo $udata['email']; ?>" required>
                </div>
              </div>

              <div class="row mb-3">
                <label class="col-sm-3 col-form-label">Phone</label>
                <div class="col-sm-9">
                  <input name="phone" type="text" class="form-control" value="<?php echo $udata['phone']; ?>" required>
                </div>
              </div>

              <div class="row mb-3">
                <label class="col-sm-3 col-form-label">Address</label>
                <div class="col-sm-9">
                  <input name="address" type="text" class="form-control" value="<?php echo $udata['address']; ?>">
                </div>
              </div>

              <div class="row mb-3">
                <label class="col-sm-3 col-form-label">OTP System</label>
                <div class="col-sm-9">
                  <select name="otp_system" class="form-control">
                    <option value="yes" <?php if($udata['otp_system'] == 'yes'){echo 'selected';} ?>>Yes</option>
                    <option value="no" <?php if($udata['otp_system'] == 'no'){echo 'selected';} ?>>No</option>
                  </select>
                </div>
              </div>

              <div class="row">
                <div class="col-sm-3"></div>
                <div class="col-sm-9">
                  <input type="submit" class="btn btn-primary px-4" value="Save Changes">
                </div>
              </div>
            </div>
          </div>
        </form>
      </div>

    </div>
  </div>
</div>
<!--end page wrapper -->

<?php include('../template/tngweb/footer.php'); ?>

<!-- Scripts -->
<script src="../template/tngweb/assets/plugins/simplebar/js/simplebar.min.js"></script>
<script src="../template/tngweb/assets/plugins/metismenu/js/metisMenu.min.js"></script>
<script src="../template/tngweb/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
<script src="../template/tngweb/assets/js/app.js"></script>

<style>
  .card {
    border-radius: 15px;
    box-shadow: 0 6px 15px rgba(0,0,0,0.1);
  }
  .btn-primary {
    border-radius: 50px;
  }
  .form-control {
    border-radius: 8px;
  }
  .list-group-item {
    border: none;
    padding: 12px 16px;
  }
  .list-group-item i {
    font-size: 1.1rem;
  }
  .list-group-item span {
    font-weight: 500;
  }
</style>
