<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/tngweb/header.php');

if(isset($_POST['send_reply'])) {
    $response = sendReply($_POST['contact_id'], $_POST['reply_message'], $_SESSION['username']);
    $success_msg = $response['msg'];
}


if(isset($_POST['update_status'])) {
    $response = updateStatus($_POST['contact_id'], $_POST['status']);
    $success_msg = $response['msg'];
}


$queries = getAllQueries();
?>

                        
                                
                                
                             
<div class="page-wrapper">
  <div class="page-content">
    <div class="card radius-15 shadow-lg border-0">
      <div class="card-body">
        <!-- Back Button -->
        <?php if(isset($success_msg)): ?>
            <div class="alert alert-success"><?php echo $success_msg; ?></div>
        <?php endif; ?>
        <div class="d-flex align-items-center justify-content-between mb-3">
          <a href="javascript:void(0);" onclick="window.history.back();" class="btn btn-outline-primary rounded-pill px-4 py-2 fw-semibold">
            <i class="bi bi-arrow-left-circle me-2"></i> Go Back
          </a>
           <h4>Contact Queries</h4>
                <span class="badge bg-primary">Total: <?php echo mysqli_num_rows($queries); ?></span>
        </div>
        <hr>

        <div class="table-responsive">
          <table id="walletTable" class="table table-hover table-striped align-middle text-center">
            <thead class="table-dark">
              <tr>
                                <th>Ticket No.</th>
                                <th>Name</th>
                                <th>Contact</th>
                                <th>Message</th>
                                <th>Status</th>
                                <th>Date</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while($query = mysqli_fetch_assoc($queries)): ?>
                            <tr>
                                <td><code><?php echo $query['ticket_number']; ?></code></td>
                                <td><?php echo htmlspecialchars($query['name']); ?></td>
                                <td>
                                    <div><?php echo htmlspecialchars($query['email']); ?></div>
                                    <small class="text-muted"><?php echo $query['mobile']; ?></small>
                                </td>
                                <td>
                                    <button class="btn btn-sm btn-outline-primary" 
                                            data-bs-toggle="modal" 
                                            data-bs-target="#messageModal<?php echo $query['id']; ?>">
                                        View Message
                                    </button>
                                </td>
                                <td>
                                    <span class="badge bg-<?php 
                                        switch($query['status']) {
                                            case 'open': echo 'warning'; break;
                                            case 'in-progress': echo 'info'; break;
                                            case 'resolved': echo 'success'; break;
                                            case 'closed': echo 'secondary'; break;
                                        }
                                    ?>"><?php echo ucfirst($query['status']); ?></span>
                                </td>
                                <td><?php echo date('M j, Y', strtotime($query['created_at'])); ?></td>
                                <td>
                                    <button class="btn btn-sm btn-success" 
                                            data-bs-toggle="modal" 
                                            data-bs-target="#replyModal<?php echo $query['id']; ?>">
                                        <i class='bx bx-reply'></i> Reply
                                    </button>
                                    <button class="btn btn-sm btn-secondary" 
                                            data-bs-toggle="modal" 
                                            data-bs-target="#statusModal<?php echo $query['id']; ?>">
                                        <i class='bx bx-cog'></i> Status
                                    </button>
                                </td>
                            </tr>

                            <!-- Message Modal -->
                            <div class="modal fade" id="messageModal<?php echo $query['id']; ?>">
                                <div class="modal-dialog modal-lg">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title">Query Details - <?php echo $query['ticket_number']; ?></h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                        </div>
                                        <div class="modal-body">
                                            <div class="row mb-3">
                                                <div class="col-md-6">
                                                    <p><strong>Name:</strong> <?php echo htmlspecialchars($query['name']); ?></p>
                                                    <p><strong>Email:</strong> <?php echo htmlspecialchars($query['email']); ?></p>
                                                    <p><strong>Mobile:</strong> <?php echo $query['mobile']; ?></p>
                                                </div>
                                                <div class="col-md-6">
                                                    <p><strong>Date:</strong> <?php echo date('M j, Y g:i A', strtotime($query['created_at'])); ?></p>
                                                    <p><strong>Status:</strong> <span class="badge bg-<?php echo $query['status'] == 'open' ? 'warning' : 'success'; ?>"><?php echo ucfirst($query['status']); ?></span></p>
                                                </div>
                                            </div>
                                            <hr>
                                            <p><strong>Message:</strong></p>
                                            <div class="border p-3 bg-light">
                                                <?php echo nl2br(htmlspecialchars($query['message'])); ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Reply Modal -->
                            <div class="modal fade" id="replyModal<?php echo $query['id']; ?>">
                                <div class="modal-dialog">
                                    <div class="modal-content">
                                        <form method="POST">
                                            <div class="modal-header">
                                                <h5 class="modal-title">Send Reply</h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                            </div>
                                            <div class="modal-body">
                                                <input type="hidden" name="contact_id" value="<?php echo $query['id']; ?>">
                                                <div class="mb-3">
                                                    <label class="form-label">To: <?php echo htmlspecialchars($query['name']); ?> (<?php echo $query['email']; ?>)</label>
                                                </div>
                                                <div class="mb-3">
                                                    <label class="form-label">Reply Message:</label>
                                                    <textarea name="reply_message" class="form-control" rows="6" required placeholder="Type your response here..."></textarea>
                                                </div>
                                                <div class="alert alert-info">
                                                    <small>This reply will be sent via email to the user.</small>
                                                </div>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                                <button type="submit" name="send_reply" class="btn btn-primary">Send Reply</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>

                            <!-- Status Modal -->
                            <div class="modal fade" id="statusModal<?php echo $query['id']; ?>">
                                <div class="modal-dialog">
                                    <div class="modal-content">
                                        <form method="POST">
                                            <div class="modal-header">
                                                <h5 class="modal-title">Update Status</h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                            </div>
                                            <div class="modal-body">
                                                <input type="hidden" name="contact_id" value="<?php echo $query['id']; ?>">
                                                <div class="mb-3">
                                                    <label class="form-label">Current Status: 
                                                        <span class="badge bg-<?php 
                                                            switch($query['status']) {
                                                                case 'open': echo 'warning'; break;
                                                                case 'in-progress': echo 'info'; break;
                                                                case 'resolved': echo 'success'; break;
                                                                case 'closed': echo 'secondary'; break;
                                                            }
                                                        ?>"><?php echo ucfirst($query['status']); ?></span>
                                                    </label>
                                                </div>
                                                <div class="mb-3">
                                                    <label class="form-label">New Status:</label>
                                                    <select name="status" class="form-select" required>
                                                        <option value="open" <?php echo $query['status'] == 'open' ? 'selected' : ''; ?>>Open</option>
                                                        <option value="in-progress" <?php echo $query['status'] == 'in-progress' ? 'selected' : ''; ?>>In Progress</option>
                                                        <option value="resolved" <?php echo $query['status'] == 'resolved' ? 'selected' : ''; ?>>Resolved</option>
                                                        <option value="closed" <?php echo $query['status'] == 'closed' ? 'selected' : ''; ?>>Closed</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                                <button type="submit" name="update_status" class="btn btn-primary">Update Status</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
     </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>
<!--end page wrapper -->

<?php include('../template/tngweb/footer.php'); ?>

<!-- âœ… DataTables CDN & Scripts -->
<script src="../template/tngweb/assets/plugins/simplebar/js/simplebar.min.js"></script>
<script src="../template/tngweb/assets/plugins/metismenu/js/metisMenu.min.js"></script>
<script src="../template/tngweb/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
<script src="../template/tngweb/assets/js/app.js"></script>


<script>
  $(document).ready(function() {
    $('#walletTable').DataTable({
      lengthChange: false,
      pageLength: 10,
      order: [[0, "desc"]],
      buttons: ['copy', 'excel', 'pdf', 'print'],
      dom: '<"d-flex justify-content-between align-items-center mb-3"Bf>rt<"d-flex justify-content-between align-items-center"ip>'
    });
  });
</script>

<style>
  /* ðŸŒŸ Stylish Table */
  .table thead th {
    vertical-align: middle;
    font-weight: 600;
    letter-spacing: 0.3px;
  }

  .table tbody tr:hover {
    background: #f5f8ff;
    transition: 0.2s ease;
  }

  .card {
    background: #fff;
    border-radius: 15px;
  }

  .btn-outline-primary {
    border-color: #0055ff;
    color: #0055ff;
  }

  .btn-outline-primary:hover {
    background-color: #0055ff;
    color: #fff;
  }

  .dataTables_wrapper .dataTables_filter input {
    border-radius: 8px;
    padding: 5px 10px;
  }

  .dataTables_wrapper .dataTables_paginate .paginate_button {
    border-radius: 5px;
  }

  .dataTables_wrapper .dt-buttons .btn {
    border-radius: 20px !important;
    font-size: 0.85rem;
    margin-right: 6px;
  }

  .badge {
    font-size: 0.8rem;
    padding: 6px 10px;
  }
</style>

</body>
</html>