<?php
session_start();
@include('./includes/config.php');

$encodedPhone = $_GET['phone'] ?? '';

if (!$encodedPhone) {
    echo "<script>
        alert('❌ Mobile number missing!');
        window.location.href = 'login.php';
    </script>";
    exit;
}

$phone = base64_decode($encodedPhone, true);

if (!$phone || !preg_match('/^[0-9]{10}$/', $phone)) {
    echo "<script>
        alert('❌ Invalid or malformed phone number!');
        window.location.href = 'login.php';
    </script>";
    exit;
}

$userQuery = mysqli_query($tng_conn, "SELECT name, type, status FROM users WHERE phone='$phone'");
if (!$userQuery || mysqli_num_rows($userQuery) == 0) {
   echo "<script>
        alert('❌ No user found with this number!');
        window.location.href = 'login.php';
    </script>";
    exit;
}

$user = mysqli_fetch_assoc($userQuery);
$userName = $user['name'] ?? 'User';
$userType = $user['type'] ?? '';
$userStatus = $user['status'] ?? '0';

// Check if user is already activated
if ($userStatus == '1') {
    echo "<script>
        alert('✅ Your account is already activated!');
        window.location.href = 'login.php';
    </script>";
    exit;
}

$regFee = 0;
if ($userType == "retailer") {
    $regFee = XyZ_val('ret_reg_fee');
} elseif ($userType == "distributor") {
    $regFee = XyZ_val('dist_reg_fee');
} else {
    $regFee = 999;
}

// ========== DITASOL INTEGRATION FUNCTIONS ==========
function createDitasolOrder($phone, $amount, $remark = 'Registration Fee') {
    $user_token = "64b25e9001d945cb1d0ab2454e40dbe1";
    $order_id = "REG_" . time() . "_" . substr($phone, -4) . "_" . rand(1000, 9999);
    
    // Important: Correct redirect URL for registration
    $redirect_url = "https://myprint.ditasol.xyz/payment.php?ditasol_return=1&phone=" . urlencode(base64_encode($phone)) . "&order_id=" . urlencode($order_id);
    
    $data = [
        'customer_mobile' => $phone,
        'user_token' => $user_token,
        'amount' => (string)$amount,
        'order_id' => $order_id,
        'redirect_url' => $redirect_url,
        'remark1' => $remark,
        'remark2' => $phone
    ];
    
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => "https://pay.ditasol.com/api/create-order",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => http_build_query($data),
        CURLOPT_HTTPHEADER => ['Content-Type: application/x-www-form-urlencoded'],
        CURLOPT_TIMEOUT => 30,
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_FOLLOWLOCATION => true
    ]);
    
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error = curl_error($ch);
    curl_close($ch);
    
    if($response && $http_code == 200) {
        $result = json_decode($response, true);
        if(isset($result['status']) && $result['status'] === true) {
            return [
                'success' => true,
                'order_id' => $order_id,
                'ditasol_order_id' => $result['result']['orderId'],
                'payment_url' => $result['result']['payment_url'],
                'message' => $result['message']
            ];
        } else {
            return [
                'success' => false,
                'error' => $result['message'] ?? 'Order creation failed'
            ];
        }
    }
    
    return [
        'success' => false, 
        'error' => 'API connection failed. HTTP: ' . $http_code . ' Error: ' . $error
    ];
}

function checkDitasolOrderStatus($order_id) {
    $user_token = "64b25e9001d945cb1d0ab2454e40dbe1";
    
    $data = [
        'user_token' => $user_token,
        'order_id' => $order_id
    ];
    
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => "https://oneadvance.online/api/check-order-status",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => http_build_query($data),
        CURLOPT_HTTPHEADER => ['Content-Type: application/x-www-form-urlencoded'],
        CURLOPT_TIMEOUT => 30,
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_FOLLOWLOCATION => true
    ]);
    
    $response = curl_exec($ch);
    $error = curl_error($ch);
    curl_close($ch);
    
    if($response) {
        $result = json_decode($response, true);
        return $result;
    }
    
    return ['status' => 'ERROR', 'message' => 'Status check failed: ' . $error];
}

// ========== HANDLE DITASOL RETURN ==========
if(isset($_GET['ditasol_return']) && $_GET['ditasol_return'] == '1' && isset($_GET['order_id'])) {
    $order_id = $_GET['order_id'] ?? '';
    
    // Check payment status
    $statusResult = checkDitasolOrderStatus($order_id);
    
    if($statusResult && isset($statusResult['status']) && $statusResult['status'] === 'COMPLETED') {
        $utr = $statusResult['result']['utr'] ?? 'DITASOL_' . time();
        $amount_paid = $statusResult['result']['amount'] ?? 0;
        $payer_name = $statusResult['result']['resultInfo'] ?? 'Ditasol Payment';
        $transaction_date = date("Y-m-d H:i:s");
        
        // Check if already processed
        $checkTxn = mysqli_query($tng_conn, "SELECT COUNT(*) as cnt FROM wallet WHERE BANKTXNID = '$utr' AND phone = '$phone'");
        $txnExists = mysqli_fetch_assoc($checkTxn)['cnt'] > 0;

        if (!$txnExists) {
            // Insert into wallet
            mysqli_query($tng_conn, "INSERT INTO wallet (phone, BANKTXNID, amount, RESPMSG, PAYMENTMODE, status, txn_date) 
                VALUES('$phone', '$utr', '$amount_paid', '$payer_name', 'DITASOL', 'success', '$transaction_date')");
            
            // Activate user account
            mysqli_query($tng_conn, "UPDATE users SET status='1' WHERE phone='$phone'");
            
            // Show success message
            echo "<!DOCTYPE html>
            <html>
            <head>
                <title>Payment Success</title>
                <meta http-equiv='refresh' content='3;url=login.php'>
                <style>
                    body { font-family: Arial; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); display: flex; justify-content: center; align-items: center; height: 100vh; margin: 0; }
                    .success-box { background: white; padding: 40px; border-radius: 15px; text-align: center; box-shadow: 0 10px 30px rgba(0,0,0,0.2); max-width: 500px; width: 90%; }
                    .success-icon { font-size: 60px; color: #28a745; margin-bottom: 20px; }
                    .details { text-align: left; background: #f8f9fa; padding: 15px; border-radius: 8px; margin: 20px 0; }
                </style>
            </head>
            <body>
                <div class='success-box'>
                    <div class='success-icon'>✅</div>
                    <h1 style='color: green;'>Payment Successful!</h1>
                    <p>Your account has been activated successfully.</p>
                    
                    <div class='details'>
                        <p><strong>Amount Paid:</strong> ₹$amount_paid</p>
                        <p><strong>UTR Number:</strong> $utr</p>
                        <p><strong>Payer Name:</strong> $payer_name</p>
                        <p><strong>Date:</strong> $transaction_date</p>
                    </div>
                    
                    <p style='color: #666;'>Redirecting to login page in 3 seconds...</p>
                </div>
            </body>
            </html>";
            exit;
        } else {
            // Already processed
            echo "<script>
                alert('✅ Payment already processed! Your account is activated.');
                window.location.href = 'login.php';
            </script>";
            exit;
        }
    } else {
        $error_msg = $statusResult['message'] ?? 'Payment failed or not completed';
        echo "<script>
            alert('❌ Payment Failed: $error_msg');
            window.location.href = 'payment.php?phone=" . urlencode($encodedPhone) . "';
        </script>";
        exit;
    }
}

// ========== CREATE DITASOL ORDER ON PAGE LOAD ==========
// Create Ditasol order for registration fee
$orderResult = createDitasolOrder($phone, $regFee, $userType . ' Registration');

if (!$orderResult['success']) {
    die("<div style='color:red;font-weight:bold;text-align:center;margin-top:20px;'>
        ❌ Payment Gateway Error: " . htmlspecialchars($orderResult['error']) . "
    </div>");
}

// Store order ID in session for reference
$_SESSION['ditasol_order_id'] = $orderResult['order_id'];
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment - Account Activation</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 20px;
        }
        
        .container {
            background: white;
            border-radius: 20px;
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.2);
            width: 100%;
            max-width: 500px;
            overflow: hidden;
        }
        
        .header {
            background: linear-gradient(to right, #4e54c8, #8f94fb);
            color: white;
            padding: 30px;
            text-align: center;
            border-bottom: 5px solid #3a3f9c;
        }
        
        .header h1 {
            font-size: 28px;
            margin-bottom: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
        }
        
        .header p {
            opacity: 0.9;
            font-size: 16px;
        }
        
        .content {
            padding: 30px;
        }
        
        .user-info {
            background: #f8f9fa;
            padding: 20px;
            border-radius: 12px;
            margin-bottom: 25px;
            border-left: 5px solid #4e54c8;
        }
        
        .user-info h2 {
            color: #333;
            margin-bottom: 10px;
            font-size: 22px;
        }
        
        .user-info p {
            color: #666;
            margin: 8px 0;
            font-size: 15px;
        }
        
        .amount-box {
            text-align: center;
            margin: 25px 0;
        }
        
        .amount-label {
            font-size: 16px;
            color: #666;
            margin-bottom: 8px;
        }
        
        .amount {
            font-size: 48px;
            font-weight: 800;
            color: #28a745;
            text-shadow: 2px 2px 4px rgba(0,0,0,0.1);
        }
        
        .payment-instructions {
            background: #e7f4ff;
            padding: 20px;
            border-radius: 12px;
            margin: 25px 0;
            border: 1px solid #b3d7ff;
        }
        
        .payment-instructions h3 {
            color: #0056b3;
            margin-bottom: 15px;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .instructions-list {
            list-style: none;
            padding-left: 0;
        }
        
        .instructions-list li {
            margin-bottom: 12px;
            padding-left: 30px;
            position: relative;
            color: #333;
            line-height: 1.5;
        }
        
        .instructions-list li i {
            position: absolute;
            left: 0;
            top: 2px;
            color: #4e54c8;
        }
        
        .payment-method {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 15px;
            margin: 20px 0;
            padding: 15px;
            background: #f8f9fa;
            border-radius: 10px;
            font-size: 16px;
        }
        
        .payment-method i {
            color: #4e54c8;
            font-size: 20px;
        }
        
        .status {
            text-align: center;
            padding: 20px;
            margin: 20px 0;
            border-radius: 10px;
            font-size: 16px;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
        }
        
        .status.checking {
            background: #fff3cd;
            color: #856404;
            border: 1px solid #ffeaa7;
        }
        
        .status.pending {
            background: #cce5ff;
            color: #004085;
            border: 1px solid #b8daff;
        }
        
        .btn {
            display: block;
            width: 100%;
            padding: 15px;
            text-align: center;
            text-decoration: none;
            border-radius: 10px;
            font-size: 16px;
            font-weight: 600;
            border: none;
            cursor: pointer;
            transition: all 0.3s ease;
            margin: 10px 0;
        }
        
        .btn-primary {
            background: linear-gradient(to right, #4e54c8, #8f94fb);
            color: white;
        }
        
        .btn-primary:hover {
            background: linear-gradient(to right, #3a3f9c, #7a7fdf);
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(78, 84, 200, 0.3);
        }
        
        .btn-secondary {
            background: #6c757d;
            color: white;
        }
        
        .btn-secondary:hover {
            background: #5a6268;
        }
        
        .login-link {
            text-align: center;
            margin-top: 20px;
            padding-top: 20px;
            border-top: 1px solid #eee;
        }
        
        .login-link a {
            color: #4e54c8;
            text-decoration: none;
            font-weight: 500;
        }
        
        .login-link a:hover {
            text-decoration: underline;
        }
        
        .payment-loader {
            text-align: center;
            padding: 20px;
        }
        
        .fa-spin {
            animation: fa-spin 1s infinite linear;
        }
        
        @keyframes fa-spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        
        .auto-redirect {
            text-align: center;
            color: #666;
            font-size: 14px;
            margin-top: 15px;
        }
        
        .order-id {
            background: #f8f9fa;
            padding: 10px;
            border-radius: 5px;
            font-family: monospace;
            font-size: 14px;
            color: #333;
            margin: 10px 0;
            word-break: break-all;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1><i class="fas fa-credit-card"></i> Complete Payment</h1>
            <p>Activate Your Account</p>
        </div>
        
        <div class="content">
            <div class="user-info">
                <h2>Hi, <?php echo htmlspecialchars($userName); ?>! 👋</h2>
                <p>Mobile: <strong><?php echo htmlspecialchars($phone); ?></strong></p>
                <p>Account Type: <strong><?php echo ucfirst($userType); ?></strong></p>
                <p>Registration Fee: <strong>₹<?php echo $regFee; ?></strong></p>
            </div>
            
            <div class="amount-box">
                <div class="amount-label">Total Amount to Pay</div>
                <div class="amount">₹<?php echo $regFee; ?></div>
            </div>
            
            <div class="payment-instructions">
                <h3><i class="fas fa-info-circle"></i> Payment Instructions</h3>
                <ul class="instructions-list">
                    <li><i class="fas fa-mouse-pointer"></i> Click the "Proceed to Payment" button below</li>
                    <li><i class="fas fa-external-link-alt"></i> You will be redirected to secure payment page</li>
                    <li><i class="fas fa-lock"></i> Complete payment using UPI, Card, or Net Banking</li>
                    <li><i class="fas fa-check-circle"></i> After payment, you'll be redirected back automatically</li>
                    <li><i class="fas fa-user-check"></i> Your account will be activated instantly</li>
                </ul>
            </div>
            
            <div class="payment-method">
                <i class="fas fa-shield-alt"></i>
                <span>Secure Payment Gateway: <strong>DITASOL PAYMENTS</strong></span>
            </div>
            
            <div class="status pending">
                <i class="fas fa-arrow-right"></i>
                Ready to process your payment
            </div>
            
            <div class="order-id">
                <strong>Order ID:</strong> <?php echo $orderResult['order_id']; ?>
            </div>
            
            <a href="<?php echo $orderResult['payment_url']; ?>" class="btn btn-primary" id="proceedBtn">
                <i class="fas fa-lock"></i> Proceed to Secure Payment
            </a>
            
            <div class="auto-redirect">
                <i class="fas fa-clock"></i>
                Auto-redirecting in <span id="countdown">5</span> seconds...
            </div>
            
            <a href="login.php" class="btn btn-secondary">
                <i class="fas fa-times-circle"></i> Cancel Payment
            </a>
            
            <div class="login-link">
                <a href="login.php"><i class="fas fa-arrow-left"></i> Return to Login Page</a>
            </div>
        </div>
    </div>

    <script>
    // Auto-redirect after 5 seconds
    let countdown = 5;
    const countdownElement = document.getElementById('countdown');
    const proceedBtn = document.getElementById('proceedBtn');
    
    function updateCountdown() {
        countdownElement.textContent = countdown;
        if (countdown > 0) {
            countdown--;
            setTimeout(updateCountdown, 1000);
        } else {
            // Auto-click the proceed button
            proceedBtn.click();
        }
    }
    
    // Start countdown
    setTimeout(updateCountdown, 1000);
    
    // Manual click handler
    proceedBtn.addEventListener('click', function(e) {
        // Show loading state
        const originalText = proceedBtn.innerHTML;
        proceedBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Redirecting to payment...';
        proceedBtn.disabled = true;
        
        // Allow the redirect to happen
        return true;
    });
    
    // If user cancels, show confirmation
    document.querySelector('.btn-secondary').addEventListener('click', function(e) {
        if (!confirm('Are you sure you want to cancel the payment? Your account will remain inactive.')) {
            e.preventDefault();
        }
    });
    </script>
</body>
</html>