<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/tngweb/header.php');

$fee = $udata['eshram_pdf_fee'];
checkServiceStatus($udata, 'eshram_pdf_fee_status');

$appliedby = $udata['phone'];
$balance   = $udata['balance'];

if (isset($_POST['aadhar'])) {

    $uid       = trim($_POST['aadhar']);
    $debit_fee = $balance - $fee;


    if ($balance < $fee) {
        echo "<script src='https://cdn.jsdelivr.net/npm/sweetalert2@11'></script>
        <script>
            Swal.fire('Low Balance','Please Recharge Wallet','error');
            setTimeout(()=>{ window.location='wallet.php'; },1500);
        </script>";
        exit;
    }


    $request = [
        'uid' => $uid
    ];

    $resdata = uid_eshram_pdf_verification_api_run($request);

    if (($resdata['sampleCode'] ?? '') !== '200') {
        echo "<script src='https://cdn.jsdelivr.net/npm/sweetalert2@11'></script>
        <script>
            Swal.fire(
                'Error',
                '".($resdata['error'] ?? 'Service Error')."',
                'error'
            );
        </script>";
    }
    else {

        date_default_timezone_set('Asia/Kolkata');
        $timestamp   = date("Y-m-d H:i:s");
        $parentPhone = $udata['parent'] ?? null;


        addCommission(
            $tng_conn,
            $appliedby,
            $fee,
            $parentPhone,
            "Eshram PDF"
        );

     
        mysqli_query(
            $tng_conn,
            "UPDATE users SET balance = balance - $fee WHERE phone = '$appliedby'"
        );

    
        mysqli_query(
            $tng_conn,
            "INSERT INTO wallethistory
            (userid,amount,balance,purpose,status,type)
            VALUES
            (
                '$appliedby',
                '$fee',
                '$debit_fee',
                'Eshram PDF',
                '1',
                'Debit'
            )"
        );


        mysqli_query(
            $tng_conn,
            "INSERT INTO all_pdf_records
            (service_name,name,username,number,pdf,date)
            VALUES
            (
                'eshram_pdf',
                '".mysqli_real_escape_string($tng_conn,$resdata['fullname'])."',
                '$appliedby',
                '".mysqli_real_escape_string($tng_conn,$resdata['aadhar'])."',
                '".mysqli_real_escape_string($tng_conn,$resdata['eshram_Pdf'])."',
                '$timestamp'
            )"
        );


        echo "<script src='https://cdn.jsdelivr.net/npm/sweetalert2@11'></script>
        <script>
        Swal.fire({
            icon:'success',
            title:'Success',
            text:'E-Shram PDF Generated Successfully',
            timer:1500,
            showConfirmButton:false
        }).then(()=>{
            window.location='all_history.php';
        });
        </script>";
    }
}
?>

<!-- ===============================
     LUXURY UI
================================ -->
<style>
.lux-card{
    border-radius:18px;
    box-shadow:0 15px 40px rgba(0,0,0,.25);
    background:linear-gradient(135deg,#ffffff,#f5f8ff);
}
.lux-title{
    background:linear-gradient(90deg,#232526,#414345);
    color:#fff;
    padding:12px;
    border-radius:10px;
    text-align:center;
    font-weight:600;
}
.lux-btn{
    background:linear-gradient(45deg,#1d2671,#c33764);
    border:none;
    border-radius:50px;
    padding:12px;
    color:#fff;
    font-weight:600;
    transition:.3s;
}
.lux-btn:hover{
    transform:scale(1.05);
}
</style>

<div class="content-wrap">
<div class="main">
<div class="page-wrapper">
<div class="page-content">
<div class="container-fluid">

<div class="row justify-content-center">
<div class="col-lg-4 col-md-6">

<div class="card lux-card">
<div class="card-body">

<a href="javascript:history.back()" class="btn btn-light mb-3 w-100">
← Go Back
</a>

<div class="lux-title mb-3">
E-Shram PDF Verification
</div>

<form method="POST" id="esharamForm">

<div class="mb-3">
<label class="fw-semibold">Enter Aadhaar Number</label>
<input type="text"
       name="aadhar"
       maxlength="12"
       class="form-control"
       placeholder="12 Digit Aadhaar"
       required>
</div>

<div class="mb-3">
<input class="form-control text-center fw-bold"
       value="Fee ₹ <?php echo $fee; ?>" readonly>
</div>

<button type="submit" class="lux-btn w-100" id="submitBtn">
Generate PDF
</button>

</form>

</div>
</div>

</div>
</div>

</div>
</div>
</div>
</div>

<?php include('../template/tngweb/footer.php'); ?>

<!-- ===============================
     CONFIRM + DOUBLE SUBMIT SAFE
================================ -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
document.addEventListener("DOMContentLoaded", function () {

  let submitting = false;
  const form = document.getElementById("esharamForm");
  const btn  = document.getElementById("submitBtn");

  form.addEventListener("submit", function(e){
    e.preventDefault();
    if (submitting) return;

    Swal.fire({
      title: 'Are you sure?',
      text: 'PDF generate hogi aur wallet se fee deduct hogi',
      icon: 'warning',
      showCancelButton: true,
      confirmButtonText: 'Yes, Proceed',
      cancelButtonText: 'Cancel'
    }).then((result)=>{
      if(result.isConfirmed){
        submitting = true;
        btn.disabled = true;
        btn.innerText = 'Processing...';
        form.submit();
      }
    });
  });

});
</script>

<script src="../template/tngweb/assets/js/bootstrap.bundle.min.js"></script>
<script src="../template/tngweb/assets/plugins/simplebar/js/simplebar.min.js"></script>
<script src="../template/tngweb/assets/plugins/metismenu/js/metisMenu.min.js"></script>
<script src="../template/tngweb/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
<script src="../template/tngweb/assets/js/app.js"></script>
</html>
