<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/tngweb/header.php');

$fee = $udata['sambal_pvc_card_pdf_mp_a'];
checkServiceStatus($udata, 'sambal_pvc_card_pdf_mp_a_status');

$appliedby = $udata['phone'];
$balance   = $udata['balance'];

if (isset($_POST['family_id'])) {

    $family_id = trim($_POST['family_id']);
    $debit_fee = $balance - $fee;

    /* ===============================
       BALANCE CHECK
    ================================ */
    if ($balance < $fee) {
        echo "<script src='https://cdn.jsdelivr.net/npm/sweetalert2@11'></script>
        <script>
            Swal.fire('Low Balance','Please Recharge Wallet','error');
            setTimeout(()=>{ window.location='wallet.php'; },1500);
        </script>";
        exit;
    }


    $request = [
        'family_id' => $family_id
    ];

    $resdata = sambal_card_pdf_mp_verification_api_run($request);

    if (($resdata['sampleCode'] ?? '') !== '200') {
        echo "<script src='https://cdn.jsdelivr.net/npm/sweetalert2@11'></script>
        <script>
            Swal.fire(
                'Error',
                '".($resdata['error'] ?? 'Service Error')."',
                'error'
            );
        </script>";
    } 
    else {

        date_default_timezone_set('Asia/Kolkata');
        $timestamp   = date("Y-m-d H:i:s");
        $parentPhone = $udata['parent'] ?? null;


        addCommission(
            $tng_conn,
            $appliedby,
            $fee,
            $parentPhone,
            "Sambal PVC Card PDF"
        );

      
        mysqli_query(
            $tng_conn,
            "UPDATE users SET balance = balance - $fee WHERE phone = '$appliedby'"
        );

 
        mysqli_query(
            $tng_conn,
            "INSERT INTO wallethistory
            (userid,amount,balance,purpose,status,type)
            VALUES
            (
                '$appliedby',
                '$fee',
                '$debit_fee',
                'Sambal PVC Card PDF',
                '1',
                'Debit'
            )"
        );


        mysqli_query(
            $tng_conn,
            "INSERT INTO all_pdf_records
            (service_name,name,username,number,pdf,date)
            VALUES
            (
                'sambal_pvc_pdf_mp',
                '".mysqli_real_escape_string($tng_conn,$resdata['name'])."',
                '$appliedby',
                '".mysqli_real_escape_string($tng_conn,$resdata['sambalId'])."',
                '".mysqli_real_escape_string($tng_conn,$resdata['pdf'])."',
                '$timestamp'
            )"
        );


        echo "<script src='https://cdn.jsdelivr.net/npm/sweetalert2@11'></script>
        <script>
        Swal.fire({
            icon:'success',
            title:'Success',
            text:'Sambal PVC Card PDF Generated Successfully',
            timer:1500,
            showConfirmButton:false
        }).then(()=>{
            window.location='all_history.php';
        });
        </script>";
    }
}
?>

<!-- ===============================
     LUXURY UI
================================ -->
<style>
.lux-card{
    border-radius:18px;
    box-shadow:0 15px 40px rgba(0,0,0,.25);
    background:linear-gradient(135deg,#ffffff,#f4f7ff);
}
.lux-title{
    background:linear-gradient(90deg,#134e5e,#71b280);
    color:#fff;
    padding:12px;
    border-radius:10px;
    text-align:center;
    font-weight:600;
}
.lux-btn{
    background:linear-gradient(45deg,#43cea2,#185a9d);
    border:none;
    border-radius:50px;
    padding:12px;
    color:#fff;
    font-weight:600;
    transition:.3s;
}
.lux-btn:hover{
    transform:scale(1.04);
}
</style>

<div class="content-wrap">
<div class="main">
<div class="page-wrapper">
<div class="page-content">
<div class="container-fluid">

<div class="row justify-content-center">
<div class="col-lg-4 col-md-6">

<div class="card lux-card">
<div class="card-body">

<a href="javascript:history.back()" class="btn btn-light mb-3 w-100">
← Go Back
</a>

<div class="lux-title mb-3">
Sambal PVC Card PDF (Madhya Pradesh)
</div>

<form method="POST" id="dlOnlyForm">

<div class="mb-3">
<label class="fw-semibold">Enter Sambal Card Number</label>
<input type="text"
       name="family_id"
       class="form-control"
       placeholder="Enter Sambal Number"
       required>
</div>

<div class="mb-3">
<input class="form-control text-center fw-bold"
       value="Fee ₹ <?php echo $fee; ?>" readonly>
</div>

<button type="submit" class="lux-btn w-100" id="submitBtn">
Generate PDF
</button>

</form>

</div>
</div>

</div>
</div>

</div>
</div>
</div>
</div>

<?php include('../template/tngweb/footer.php'); ?>

<!-- ===============================
     CONFIRM + DOUBLE SUBMIT SAFE
================================ -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
document.addEventListener("DOMContentLoaded", function () {

  let submitting = false;
  const form = document.getElementById("dlOnlyForm");
  const btn  = document.getElementById("submitBtn");

  form.addEventListener("submit", function(e){
    e.preventDefault();
    if (submitting) return;

    Swal.fire({
      title: 'Are you sure?',
      text: 'PDF generate hogi aur wallet se fee deduct hogi',
      icon: 'warning',
      showCancelButton: true,
      confirmButtonText: 'Yes, Proceed',
      cancelButtonText: 'Cancel'
    }).then((result)=>{
      if(result.isConfirmed){
        submitting = true;
        btn.disabled = true;
        btn.innerText = 'Processing...';
        form.submit();
      }
    });
  });

});
</script>

<script src="../template/tngweb/assets/js/bootstrap.bundle.min.js"></script>
<script src="../template/tngweb/assets/plugins/simplebar/js/simplebar.min.js"></script>
<script src="../template/tngweb/assets/plugins/metismenu/js/metisMenu.min.js"></script>
<script src="../template/tngweb/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
<script src="../template/tngweb/assets/js/app.js"></script>
</html>
