<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/tngweb/header.php');

$fee = $udata['janadhar_pdf_fee'];
checkServiceStatus($udata, 'janadhar_pdf_fee_status');

$appliedby = $udata['phone'];
$balance   = $udata['balance'];


if (!empty($_POST['janaadhar'])) {

    $janaadhar = trim($_POST['janaadhar']);
    $debit_fee = $balance - $fee;

    if ($balance < $fee) {
        echo "<script src='https://cdn.jsdelivr.net/npm/sweetalert2@11'></script>
        <script>
            Swal.fire('Low Balance','Please Recharge Wallet','error');
            setTimeout(()=>{ window.location='wallet.php'; },1500);
        </script>";
        exit;
    }

    $request = [
        'janaadhar' => $janaadhar
    ];

    $resdata = janaadharpdf_rj_verification_api_run($request);

    if (!empty($resdata['error'])) {
        echo "<script src='https://cdn.jsdelivr.net/npm/sweetalert2@11'></script>
        <script>
            Swal.fire('Error','".htmlspecialchars($resdata['error'])."','error');
        </script>";
    }
    elseif (($resdata['sampleCode'] ?? '') === "200") {

        date_default_timezone_set('Asia/Kolkata');
        $timestamp   = date("Y-m-d H:i:s");
        $parentPhone = $udata['parent'] ?? null;


        addCommission(
            $tng_conn,
            $appliedby,
            $fee,
            $parentPhone,
            "JanAadhar PDF Rajasthan"
        );

 
        mysqli_query(
            $tng_conn,
            "UPDATE users SET balance = balance - $fee WHERE phone='$appliedby'"
        );

   
        mysqli_query(
            $tng_conn,
            "INSERT INTO wallethistory
            (userid,amount,balance,purpose,status,type)
            VALUES
            (
                '$appliedby',
                '$fee',
                '$debit_fee',
                'JanAadhar PDF Rajasthan',
                '1',
                'Debit'
            )"
        );


        mysqli_query(
            $tng_conn,
            "INSERT INTO all_pdf_records
            (service_name,name,username,number,pdf,date)
            VALUES
            (
                'jan_aadhar_pdf_rj',
                'JanAadhar Rajasthan',
                '$appliedby',
                '".mysqli_real_escape_string($tng_conn, $resdata['janaadhar'])."',
                '".mysqli_real_escape_string($tng_conn, $resdata['pdf'])."',
                '$timestamp'
            )"
        );

 
        echo "<script src='https://cdn.jsdelivr.net/npm/sweetalert2@11'></script>
        <script>
        Swal.fire({
            icon:'success',
            title:'Success',
            text:'JanAadhar PDF Generated Successfully',
            timer:1500,
            showConfirmButton:false
        }).then(()=>{
            window.location='all_history.php';
        });
        </script>";
    }
}
?>

<!-- ===============================
     LUXURY UI
================================ -->
<style>
.jan-card{
    border-radius:18px;
    box-shadow:0 18px 40px rgba(0,0,0,.2);
    background:linear-gradient(135deg,#ffffff,#f1f5ff);
}
.jan-title{
    background:linear-gradient(90deg,#b31217,#e52d27);
    color:#fff;
    padding:12px;
    border-radius:12px;
    text-align:center;
    font-weight:600;
}
.jan-btn{
    background:linear-gradient(45deg,#0f2027,#203a43,#2c5364);
    border:none;
    border-radius:50px;
    padding:12px;
    color:#fff;
    font-weight:600;
}
.jan-btn:hover{ transform:scale(1.04); }
</style>

<div class="content-wrap">
<div class="main">
<div class="page-wrapper">
<div class="page-content">
<div class="container-fluid">

<div class="row justify-content-center">
<div class="col-lg-4 col-md-6">

<div class="card jan-card">
<div class="card-body">

<a href="javascript:history.back()" class="btn btn-light mb-3 w-100">
← Go Back
</a>

<div class="jan-title mb-3">
JanAadhar PDF Rajasthan
</div>

<form method="POST" id="janForm">

<div class="mb-3">
<label class="fw-semibold">Enter JanAadhar Number</label>
<input type="text" name="janaadhar"
       minlength="9" maxlength="20"
       class="form-control" required>
</div>

<div class="mb-3">
<input class="form-control text-center fw-bold"
       value="Fee ₹ <?php echo $fee; ?>" readonly>
</div>

<button type="submit" id="submitBtn" class="jan-btn w-100">
Generate PDF
</button>

</form>

</div>
</div>

</div>
</div>

</div>
</div>
</div>
</div>

<?php include('../template/tngweb/footer.php'); ?>

<!-- ===============================
     CONFIRM + DOUBLE SUBMIT SAFE
================================ -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
document.addEventListener("DOMContentLoaded", function () {

let submitting = false;
const form = document.getElementById("janForm");
const btn  = document.getElementById("submitBtn");

form.addEventListener("submit", function(e){
  e.preventDefault();
  if (submitting) return;

  Swal.fire({
    title:'Are you sure?',
    text:'PDF generate hogi aur wallet se fee deduct hogi',
    icon:'warning',
    showCancelButton:true,
    confirmButtonText:'Yes, Proceed',
    cancelButtonText:'Cancel'
  }).then((r)=>{
    if(r.isConfirmed){
      submitting=true;
      btn.disabled=true;
      btn.innerText='Processing...';
      form.submit();
    }
  });
});

});
</script>

<script src="../template/tngweb/assets/js/bootstrap.bundle.min.js"></script>
<script src="../template/tngweb/assets/plugins/simplebar/js/simplebar.min.js"></script>
<script src="../template/tngweb/assets/plugins/metismenu/js/metisMenu.min.js"></script>
<script src="../template/tngweb/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
<script src="../template/tngweb/assets/js/app.js"></script>
</html>
