<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/tngweb/header.php');

$fee = $udata['janadhar_find_fee'];
checkServiceStatus($udata,'janadhar_find_fee_status');

if ($_SERVER['REQUEST_METHOD']==='POST' && !empty($_POST['aadhar'])) {

    $aadhar = trim($_POST['aadhar']);
    $user   = $udata['phone'];
    $wallet = $udata['balance'];

    // ❌ LOW BALANCE
    if ($wallet < $fee) {
        echo "<script>
            Swal.fire('Wallet Low','Please recharge wallet','error')
            .then(()=>window.location='wallet.php');
        </script>";
        exit;
    }

    // API CALL
    $resdata = janaadharFind_rj_verification_api_run([
        'aadhar' => $aadhar
    ]);

    $sampleCode = $resdata['sampleCode'] ?? '';
    $errorMsg   = $resdata['error'] ?? 'Invalid Aadhaar or data not found';

    // ❌ ERROR
    if ($sampleCode !== "200") {
        echo "<script>
            Swal.fire('Failed','".addslashes($errorMsg)."','error');
        </script>";
        exit;
    }

    /* ✅ SUCCESS */

    // Debit Wallet
    mysqli_query(
        $tng_conn,
        "UPDATE users SET balance=balance-$fee WHERE phone='$user'"
    );

    // Commission
    addCommission(
        $tng_conn,
        $user,
        $fee,
        $udata['parent'] ?? null,
        'JAN AADHAAR FIND'
    );

    // Wallet History
    mysqli_query(
        $tng_conn,
        "INSERT INTO wallethistory
        (userid,amount,balance,purpose,status,type)
        VALUES(
            '$user',
            '$fee',
            '".($wallet-$fee)."',
            'JAN AADHAAR FIND',
            '1',
            'Debit'
        )"
    );

    // BASE64 JSON SAVE
    $base64Json = base64_encode(
        json_encode($resdata, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES)
    );

    mysqli_query(
        $tng_conn,
        "INSERT INTO all_pdf_records
        (service_name,name,username,number,pdf,date)
        VALUES(
            'JAN_AADHAAR_FIND',
            '".$resdata['janaadhaar']."',
            '$user',
            '$aadhar',
            '".mysqli_real_escape_string($tng_conn,$base64Json)."',
            NOW()
        )"
    );

    // SUCCESS POPUP + REDIRECT
    echo "<script>
        Swal.fire({
            icon:'success',
            title:'Jan Aadhaar Found',
            text:'Details saved successfully',
            timer:2200,
            showConfirmButton:false
        }).then(()=>window.location='all_history.php');
    </script>";
    exit;
}
?>

<!-- ================= UI ================= -->
<style>
body{
  background:linear-gradient(135deg,#eef2ff,#fdfcfb);
}
.glass{
  background:rgba(255,255,255,.97);
  backdrop-filter:blur(18px);
  border-radius:24px;
  box-shadow:0 25px 45px rgba(0,0,0,.12);
  padding:32px;
}
.title{
  font-weight:700;
  color:#78350f;
}
.back-btn{
  text-decoration:none;
  font-weight:600;
}
</style>

<div class="page-wrapper">
<div class="page-content">
<div class="container">

<div class="row justify-content-center align-items-center" style="min-height:80vh;">
<div class="col-lg-5 col-md-7 col-sm-10">

<div class="glass">

<div class="mb-3">
  <a href="javascript:history.back()" class="back-btn text-primary">
    <i class="bi bi-arrow-left-circle"></i> Back
  </a>
</div>

<h4 class="title text-center mb-1">
🟠 Jan Aadhaar Find
</h4>

<p class="text-muted text-center mb-4">
Rajasthan • Aadhaar to Jan Aadhaar
</p>

<form method="post" id="janForm">

<div class="mb-3">
  <label class="fw-semibold">Aadhaar Number</label>
  <input type="text"
         name="aadhar"
         maxlength="12"
         minlength="12"
         class="form-control form-control-lg"
         placeholder="Enter 12 digit Aadhaar"
         required>
</div>

<div class="row mt-4 align-items-center">
  <div class="col-6">
    <input class="form-control fw-bold text-success"
           value="Fee ₹ <?= $fee ?>" readonly>
  </div>
  <div class="col-6 text-end">
    <button type="submit"
            id="submitBtn"
            class="btn btn-success px-4 rounded-pill">
      <i class="fa fa-search"></i> Find
    </button>
  </div>
</div>

</form>

</div>
</div>
</div>

</div>
</div>
</div>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
let locked=false;
document.getElementById('janForm').addEventListener('submit',function(e){
  e.preventDefault();
  if(locked) return;

  Swal.fire({
    title:'Confirm?',
    text:'Proceed to find Jan Aadhaar?',
    icon:'question',
    showCancelButton:true,
    confirmButtonText:'Yes',
    cancelButtonText:'Cancel'
  }).then(r=>{
    if(r.isConfirmed){
      locked=true;
      document.getElementById('submitBtn').disabled=true;
      this.submit();
    }
  });
});
</script>

<?php include('../template/tngweb/footer.php'); ?>
