<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/tngweb/header.php');

if (isset($_POST['addlink']) && $udata['id'] > 0 && strtolower($udata['type']) === 'admin') {
    $name = $_POST['name'] ?? '';
    $url  = $_POST['url'] ?? '';

    if (!empty($name) && !empty($url)) {
        if (addImportantLink($tng_conn, $name, $url)) {
            swal_alert("✅ Add Link Successfully!", 'success', '');
        } else {
            swal_alert("❌ Server Error: " . mysqli_error($tng_conn), 'error', '');
        }
    } else {
        swal_alert("⚠️ Please fill all valid details!", 'warning');
    }
}

if (isset($_POST['delete']) && $udata['id'] > 0 && strtolower($udata['type']) === 'admin') {
    $id = $_POST['id'] ?? '';
    if (!empty($id)) {
        if (deleteImportantLink($tng_conn, $id)) {
            swal_alert("✅ Link Delete Successfully!", 'success', '');
        } else {
            swal_alert("❌ Server Error: " . mysqli_error($tng_conn), 'error');
        }
    } else {
        swal_alert("⚠️ Invalid Request!", 'warning');
    }
}
?>

<!--start page wrapper -->
<div class="page-wrapper">
  <div class="page-content">
    <div class="card radius-15 shadow-lg border-0">
      <div class="card-body">
        <!-- Back Button -->
        <div class="d-flex align-items-center justify-content-between mb-3">
          <a href="javascript:void(0);" onclick="window.history.back();" class="btn btn-outline-primary rounded-pill px-4 py-2 fw-semibold">
            <i class="bi bi-arrow-left-circle me-2"></i> Go Back
          </a>
          <h5 class="mb-0">🌐 Manage Important Links</h5>
        </div>

      <?php if (strtolower($udata['type']) === 'admin') { ?>
      <form class="row p-4" method="POST" action="">
        <div class="col-md-3 mb-3">
          <label>Name</label>
          <input type="text" class="form-control" placeholder="Enter Name" name="name" required>
        </div>
        <div class="col-md-6 mb-3">
          <label>URL</label>
          <input type="url" class="form-control" placeholder="Enter URL" name="url" required>
        </div>
        <div class="col-md-3 mb-3">
          <label>&nbsp;</label>
          <button type="submit" class="btn btn-success w-100" name="addlink">➕ Add Link</button>
        </div>
      </form>
      <?php } ?>

     <div class="table-responsive">
          <table id="walletTable" class="table table-hover table-striped align-middle text-center">
            <thead class="table-dark">
            <tr class="bg-secondary text-white">
              <th>SL No</th>
              <th>Name</th>
              <th>Link</th>
              <?php if (strtolower($udata['type']) === 'admin') { ?>
              <th>Action</th>
              <?php } ?>
            </tr>
          </thead>
          <tbody>
            <?php
            $links = fetchImportantLinks($tng_conn);
            $sl = 1;
            foreach ($links as $value) {
            ?>
            <tr>
              <td><?= $sl ?></td>
              <td><?= htmlspecialchars($value['name']) ?></td>
              <td><a href="<?= htmlspecialchars($value['url']) ?>" target="_blank"><i class="fas fa-link"></i> Open</a></td>
              <?php if (strtolower($udata['type']) === 'admin') { ?>
              <td>
                <form method="POST" action="">
                  <input type="hidden" name="id" value="<?= $value['id'] ?>">
                  <button type="submit" class="btn btn-danger btn-xs mb-2" name="delete" title="Delete" onclick="return confirm('Are you sure?');">
                    <i class="fas fa-trash"></i>
                  </button>
                </form>
              </td>
              <?php } ?>
            </tr>
            <?php $sl++; } ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>
<!--end page wrapper -->

<?php include('../template/tngweb/footer.php'); ?>

<!-- ✅ DataTables CDN & Scripts -->
<script src="../template/tngweb/assets/plugins/simplebar/js/simplebar.min.js"></script>
<script src="../template/tngweb/assets/plugins/metismenu/js/metisMenu.min.js"></script>
<script src="../template/tngweb/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
<script src="../template/tngweb/assets/js/app.js"></script>


<script>
  $(document).ready(function() {
    $('#walletTable').DataTable({
      lengthChange: false,
      pageLength: 10,
      order: [[0, "desc"]],
      buttons: ['copy', 'excel', 'pdf', 'print'],
      dom: '<"d-flex justify-content-between align-items-center mb-3"Bf>rt<"d-flex justify-content-between align-items-center"ip>'
    });
  });
</script>

<style>
  /* 🌟 Stylish Table */
  .table thead th {
    vertical-align: middle;
    font-weight: 600;
    letter-spacing: 0.3px;
  }

  .table tbody tr:hover {
    background: #f5f8ff;
    transition: 0.2s ease;
  }

  .card {
    background: #fff;
    border-radius: 15px;
  }

  .btn-outline-primary {
    border-color: #0055ff;
    color: #0055ff;
  }

  .btn-outline-primary:hover {
    background-color: #0055ff;
    color: #fff;
  }

  .dataTables_wrapper .dataTables_filter input {
    border-radius: 8px;
    padding: 5px 10px;
  }

  .dataTables_wrapper .dataTables_paginate .paginate_button {
    border-radius: 5px;
  }

  .dataTables_wrapper .dt-buttons .btn {
    border-radius: 20px !important;
    font-size: 0.85rem;
    margin-right: 6px;
  }

  .badge {
    font-size: 0.8rem;
    padding: 6px 10px;
  }
</style>
