<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/tngweb/header.php');

$fee = $udata['ifsc_lookup'];
checkServiceStatus($udata,'ifsc_lookup_status');

if ($_SERVER['REQUEST_METHOD']==='POST' && !empty($_POST['IfscCode'])) {

    $ifsc   = strtoupper(trim($_POST['IfscCode']));
    $user   = $udata['phone'];
    $wallet = $udata['balance'];

    // ❌ LOW WALLET
    if ($wallet < $fee) {
        echo "<script>
            Swal.fire('Low Balance','Please recharge wallet','error')
            .then(()=>window.location='wallet.php');
        </script>";
        exit;
    }

    // API CALL
    $resdata = ifscCode_to_Bank_verification_api_run([
        'IfscCode' => $ifsc
    ]);

    $sampleCode = $resdata['sampleCode'] ?? '';
    $errorMsg   = $resdata['Message'] ?? 'Invalid IFSC or API error';

    // ❌ ERROR CASE
    if ($sampleCode !== "200") {
        echo "<script>
            Swal.fire('Failed','".addslashes($errorMsg)."','error');
        </script>";
        exit;
    }

    /* ✅ SUCCESS CASE */

    // DEBIT WALLET
    mysqli_query(
        $tng_conn,
        "UPDATE users SET balance=balance-$fee WHERE phone='$user'"
    );

    // COMMISSION
    addCommission(
        $tng_conn,
        $user,
        $fee,
        $udata['parent'] ?? null,
        'IFSC LOOKUP'
    );

    // WALLET HISTORY
    mysqli_query(
        $tng_conn,
        "INSERT INTO wallethistory
        (userid,amount,balance,purpose,status,type)
        VALUES(
            '$user',
            '$fee',
            '".($wallet-$fee)."',
            'IFSC LOOKUP',
            '1',
            'Debit'
        )"
    );

    // SAVE FULL API RESPONSE (BASE64 JSON)
    $base64Json = base64_encode(
        json_encode($resdata, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES)
    );

    mysqli_query(
        $tng_conn,
        "INSERT INTO all_pdf_records
        (service_name,name,username,number,pdf,date)
        VALUES(
            'IFSC_LOOKUP',
            '$ifsc',
            '$user',
            '$ifsc',
            '".mysqli_real_escape_string($tng_conn,$base64Json)."',
            NOW()
        )"
    );

    // SUCCESS + REDIRECT
    echo "<script>
        Swal.fire({
            icon:'success',
            title:'IFSC Verified',
            text:'Bank details saved successfully',
            timer:2200,
            showConfirmButton:false
        }).then(()=>window.location='all_history.php');
    </script>";
    exit;
}
?>

<!-- =============== LUXURY UI =============== -->
<style>
body{
  background:linear-gradient(135deg,#eef2ff,#f9fafb);
}
.glass{
  background:rgba(255,255,255,.96);
  backdrop-filter:blur(18px);
  border-radius:22px;
  box-shadow:0 25px 50px rgba(0,0,0,.12);
  padding:32px;
}
.title{
  font-weight:700;
  color:#4338ca;
}
.back-btn{
  text-decoration:none;
  font-weight:600;
}
</style>

<div class="page-wrapper">
<div class="page-content">
<div class="container">

<div class="row justify-content-center align-items-center" style="min-height:80vh;">
<div class="col-lg-5 col-md-7 col-sm-10">

<div class="glass">

<div class="mb-3">
  <a href="javascript:history.back()" class="back-btn text-primary">
    <i class="bi bi-arrow-left-circle"></i> Back
  </a>
</div>

<h4 class="title text-center mb-2">
🏦 IFSC Code Lookup
</h4>

<p class="text-muted text-center mb-4">
Find bank details instantly using IFSC code
</p>

<form method="post" id="ifscForm">

<div class="mb-3">
  <label class="fw-semibold">IFSC Code</label>
  <input type="text"
         name="IfscCode"
         class="form-control form-control-lg"
         placeholder="e.g. SBIN0000123"
         required>
</div>

<div class="row mt-4 align-items-center">
  <div class="col-6">
    <input class="form-control fw-bold text-success"
           value="Fee ₹ <?= $fee ?>" readonly>
  </div>
  <div class="col-6 text-end">
    <button type="submit"
            id="submitBtn"
            class="btn btn-primary px-4 rounded-pill">
      <i class="fa fa-search"></i> Verify
    </button>
  </div>
</div>

</form>

</div>
</div>
</div>

</div>
</div>
</div>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
let locked=false;
document.getElementById('ifscForm').addEventListener('submit',function(e){
  e.preventDefault();
  if(locked) return;

  Swal.fire({
    title:'Confirm?',
    text:'Proceed to verify IFSC code?',
    icon:'question',
    showCancelButton:true,
    confirmButtonText:'Yes',
    cancelButtonText:'Cancel'
  }).then(res=>{
    if(res.isConfirmed){
      locked=true;
      document.getElementById('submitBtn').disabled=true;
      this.submit();
    }
  });
});
</script>

<?php include('../template/tngweb/footer.php'); ?>
