<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/tngweb/header.php');

$fee = $udata['gst_to_pan_fee'];
checkServiceStatus($udata,'gst_to_pan_fee_status');

if ($_SERVER['REQUEST_METHOD']==='POST' && !empty($_POST['inputGST'])) {

    $gstin   = strtoupper(trim($_POST['inputGST']));
    $user    = $udata['phone'];
    $balance = $udata['balance'];

    if ($balance < $fee) {
        echo "<script>
            Swal.fire('Low Balance','Please recharge wallet','error')
                 .then(()=>window.location='wallet.php');
        </script>";
        exit;
    }

    $resdata = gst_to_pan_verification_api_run([
        'gstin'=>$gstin
    ]);

    $sampleCode = $resdata['sampleCode'] ?? '';
    $error      = $resdata['error'] ?? '';

    // ❌ ERROR
    if ($sampleCode!=="200") {
        echo "<script>
            Swal.fire('Failed','".addslashes($error ?: 'Invalid GST / API Error')."','error');
        </script>";
        exit;
    }

    // ✅ SUCCESS
    $parent = $udata['parent'] ?? null;

    // wallet debit
    mysqli_query($tng_conn,"
        UPDATE users SET balance=balance-$fee WHERE phone='$user'
    ");

    addCommission($tng_conn,$user,$fee,$parent,'GST TO PAN');

    mysqli_query($tng_conn,"
        INSERT INTO wallethistory(userid,amount,balance,purpose,status,type)
        VALUES('$user','$fee','".($balance-$fee)."','GST TO PAN','1','Debit')
    ");

    // BASE64 JSON SAVE
    $base64Json = base64_encode(
        json_encode($resdata,JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES)
    );

    mysqli_query($tng_conn,"
        INSERT INTO all_pdf_records
        (service_name,name,username,number,pdf,date)
        VALUES(
            'GST_TO_PAN',
            '".mysqli_real_escape_string($tng_conn,$resdata['fullname'] ?? 'GST Holder')."',
            '$user',
            '".mysqli_real_escape_string($tng_conn,$gstin)."',
            '".mysqli_real_escape_string($tng_conn,$base64Json)."',
            NOW()
        )
    ");

    echo "<script>
        Swal.fire({
            icon:'success',
            title:'GST Verified',
            text:'PAN details fetched successfully',
            timer:2200,
            showConfirmButton:false
        }).then(()=>window.location='all_history.php');
    </script>";
    exit;
}
?>

<!-- ============ LUXURY UI ============ -->
<style>
body{
  background:linear-gradient(135deg,#eef2ff,#f9fafb);
}
.glass{
  background:rgba(255,255,255,.93);
  backdrop-filter:blur(16px);
  border-radius:22px;
  box-shadow:0 25px 50px rgba(0,0,0,.12);
  padding:32px;
}
.title{
  font-weight:700;
  color:#4338ca;
}
.back-btn{
  font-weight:600;
  text-decoration:none;
}
</style>

<div class="page-wrapper">
<div class="page-content">
<div class="container">

<div class="row justify-content-center align-items-center" style="min-height:80vh;">
<div class="col-lg-5 col-md-7 col-sm-10">

<div class="glass">

<div class="mb-3">
  <a href="javascript:history.back()" class="back-btn text-primary">
    <i class="bi bi-arrow-left-circle"></i> Back
  </a>
</div>

<h4 class="title text-center mb-2">🏢 GST to PAN Finder</h4>
<p class="text-muted text-center mb-4">
  Verify PAN details using GST Number
</p>

<form method="post" id="gstForm">

<div class="mb-3">
  <label class="fw-semibold">GST Number</label>
  <input type="text" name="inputGST"
         class="form-control form-control-lg"
         placeholder="Enter GSTIN"
         required>
</div>

<div class="row mt-4 align-items-center">
  <div class="col-6">
    <input class="form-control text-success fw-bold"
           value="Fee ₹ <?= $fee ?>" readonly>
  </div>
  <div class="col-6 text-end">
    <button type="submit" id="submitBtn"
            class="btn btn-primary px-4 rounded-pill">
      <i class="fa fa-search"></i> Verify
    </button>
  </div>
</div>

</form>

</div>
</div>
</div>

</div>
</div>
</div>

<!-- ============ CONFIRM + DOUBLE SUBMIT ============ -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
let locked=false;
document.getElementById('gstForm').addEventListener('submit',function(e){
  e.preventDefault();
  if(locked) return;

  Swal.fire({
    title:'Confirm?',
    text:'Proceed to verify GST details',
    icon:'question',
    showCancelButton:true,
    confirmButtonText:'Yes',
    cancelButtonText:'Cancel'
  }).then(r=>{
    if(r.isConfirmed){
      locked=true;
      document.getElementById('submitBtn').disabled=true;
      this.submit();
    }
  });
});
</script>

<?php include('../template/tngweb/footer.php'); ?>
