<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/tngweb/header.php');

$fee = $udata['engine_2_rc'] ?? 20;
checkServiceStatus($udata, 'engine_2_rc_status');

if ($_SERVER['REQUEST_METHOD']==='POST' && !empty($_POST['engineNumber'])) {

    $engineNumber = trim($_POST['engineNumber']);
    $user         = $udata['phone'];
    $wallet       = $udata['balance'];
    $afterBal     = $wallet - $fee;


    if ($wallet < $fee) {
        echo "<script>
            Swal.fire('Wallet Low','Please recharge your wallet','error')
            .then(()=>window.location='wallet.php');
        </script>";
        exit;
    }

    $resdata = engine_to_rc_verification_api_run([
        'engineNumber' => $engineNumber
    ]);

    $sampleCode = $resdata['sampleCode'] ?? '';
    $errorMsg   = $resdata['error'] ?? '';

 
    if (!empty($errorMsg)) {
        echo "<script>
            Swal.fire('Failed','".addslashes($errorMsg)."','error');
        </script>";
        exit;
    }

   
    if ($sampleCode === "200") {

      
        mysqli_query($tng_conn,
            "UPDATE users SET balance = balance - $fee WHERE phone='$user'"
        );

       
        addCommission(
            $tng_conn,
            $user,
            $fee,
            $udata['parent'] ?? null,
            'Engine To RC Verification'
        );

       
        mysqli_query($tng_conn,
            "INSERT INTO wallethistory
            (userid,amount,balance,purpose,status,type)
            VALUES(
                '$user','$fee','$afterBal',
                'Engine To RC Verification','1','Debit'
            )"
        );

       
        $jsonBase64 = base64_encode(
            json_encode($resdata, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES)
        );

        mysqli_query($tng_conn,
            "INSERT INTO all_pdf_records
            (service_name,name,username,number,pdf,date)
            VALUES(
                'ENGINE_TO_RC',
                '".mysqli_real_escape_string($tng_conn,$resdata['vehicle_num'] ?? 'Engine RC Result')."',
                '$user',
                '".mysqli_real_escape_string($tng_conn,$engineNumber)."',
                '".mysqli_real_escape_string($tng_conn,$jsonBase64)."',
                NOW()
            )"
        );

     
        echo "<script>
            Swal.fire({
                icon:'success',
                title:'Success',
                text:'RC details fetched & saved',
                timer:2200,
                showConfirmButton:false
            }).then(()=>window.location='all_history.php');
        </script>";
        exit;
    }
}
?>

<!-- ========== LUXURY CENTER UI ========== -->
<style>
body{
  background:linear-gradient(135deg,#eef2ff,#f9fafb);
}
.lux-card{
  background:rgba(255,255,255,0.9);
  backdrop-filter:blur(16px);
  border-radius:22px;
  box-shadow:0 25px 50px rgba(0,0,0,.1);
  padding:28px;
}
.lux-title{
  font-weight:700;
  color:#4338ca;
}
.back-btn{
  font-weight:600;
  text-decoration:none;
}
</style>

<div class="page-wrapper">
<div class="page-content">
<div class="container">

<div class="row justify-content-center align-items-center" style="min-height:80vh;">
<div class="col-lg-5 col-md-7 col-sm-10">

<div class="lux-card">

<div class="mb-3">
  <a href="javascript:history.back()" class="back-btn text-primary">
    <i class="bi bi-arrow-left-circle"></i> Back
  </a>
</div>

<h4 class="lux-title text-center mb-2">
  🚗 Engine → RC Verification
</h4>
<p class="text-muted text-center mb-4">
  Find RC details using Engine Number (All States)
</p>

<form method="post" id="engineForm">

<div class="mb-3">
  <label class="fw-semibold">Engine Number</label>
  <input type="text" name="engineNumber"
         class="form-control form-control-lg"
         placeholder="Enter Engine Number" required>
</div>

<div class="row align-items-center mt-4">
  <div class="col-6">
    <input class="form-control fw-bold text-primary"
           value="Fee ₹ <?php echo $fee; ?>" readonly>
  </div>
  <div class="col-6 text-end">
    <button type="submit" id="submitBtn"
            class="btn btn-primary px-4 rounded-pill">
      <i class="fa fa-check-circle"></i> Verify
    </button>
  </div>
</div>

</form>

</div>
</div>
</div>

</div>
</div>
</div>

<!-- ========== CONFIRM + DOUBLE SUBMIT BLOCK ========== -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
let locked=false;
document.getElementById('engineForm').addEventListener('submit',function(e){
  e.preventDefault();
  if(locked) return;

  Swal.fire({
    title:'Are you sure?',
    text:'Wallet balance will be deducted',
    icon:'question',
    showCancelButton:true,
    confirmButtonText:'Yes, Continue',
    cancelButtonText:'Cancel'
  }).then(r=>{
    if(r.isConfirmed){
      locked=true;
      document.getElementById('submitBtn').disabled=true;
      this.submit();
    }
  });
});
</script>

<?php include('../template/tngweb/footer.php'); ?>
