<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/tngweb/header.php');

$fee = $udata['electricBillPDF_Br_a'];
checkServiceStatus($udata, 'electricBillPDF_Br_a_status');

$appliedby = $udata['phone'];
$balance   = $udata['balance'];


if (!empty($_POST['caNumber'])) {

    $caNumber  = trim($_POST['caNumber']);
    $debit_fee = $balance - $fee;

    if ($balance < $fee) {
        echo "<script src='https://cdn.jsdelivr.net/npm/sweetalert2@11'></script>
        <script>
            Swal.fire('Low Balance','Please Recharge Wallet','error');
            setTimeout(()=>{ window.location='wallet.php'; },1500);
        </script>";
        exit;
    }

    $request = [
        'caNumber' => $caNumber
    ];

    $resdata = electricBillPDF_Br_verification_api_run($request);


    if (!empty($resdata['error'])) {
        echo "<script src='https://cdn.jsdelivr.net/npm/sweetalert2@11'></script>
        <script>
            Swal.fire('Error','".htmlspecialchars($resdata['error'])."','error');
        </script>";
    }


    elseif (($resdata['sampleCode'] ?? '') === "200") {

        date_default_timezone_set('Asia/Kolkata');
        $timestamp   = date("Y-m-d H:i:s");
        $parentPhone = $udata['parent'] ?? null;

       
        addCommission(
            $tng_conn,
            $appliedby,
            $fee,
            $parentPhone,
            'Electric Bill PDF Bihar'
        );

        
        mysqli_query(
            $tng_conn,
            "UPDATE users SET balance = balance - $fee WHERE phone='$appliedby'"
        );

        mysqli_query(
            $tng_conn,
            "INSERT INTO wallethistory
            (userid,amount,balance,purpose,status,type)
            VALUES
            (
                '$appliedby',
                '$fee',
                '$debit_fee',
                'Electric Bill PDF Bihar',
                '1',
                'Debit'
            )"
        );

    
        mysqli_query(
            $tng_conn,
            "INSERT INTO all_pdf_records
            (service_name,name,username,number,pdf,date)
            VALUES
            (
                'electric_bill_pdf_bihar',
                '".mysqli_real_escape_string($tng_conn,$resdata['provider'])."',
                '$appliedby',
                '".mysqli_real_escape_string($tng_conn,$resdata['caNumber'])."',
                '".mysqli_real_escape_string($tng_conn,$resdata['pdf'])."',
                '$timestamp'
            )"
        );

        echo "<script src='https://cdn.jsdelivr.net/npm/sweetalert2@11'></script>
        <script>
        Swal.fire({
            icon:'success',
            title:'Success',
            text:'Electric Bill PDF Generated Successfully',
            timer:1500,
            showConfirmButton:false
        }).then(()=>{
            window.location='all_history.php';
        });
        </script>";
    }
}
?>

<!-- ===============================
     LUXURY UI
================================ -->
<style>
.bill-card{
    border-radius:18px;
    box-shadow:0 18px 45px rgba(0,0,0,.25);
    background:linear-gradient(135deg,#ffffff,#eef3ff);
}
.bill-title{
    background:linear-gradient(90deg,#0f2027,#203a43,#2c5364);
    color:#fff;
    padding:14px;
    border-radius:14px;
    text-align:center;
    font-weight:600;
}
.bill-btn{
    background:linear-gradient(45deg,#0f2027,#203a43,#2c5364);
    border:none;
    border-radius:50px;
    padding:12px;
    color:#fff;
    font-weight:600;
}
.bill-btn:hover{ transform:scale(1.05); }
</style>

<div class="content-wrap">
<div class="main">
<div class="page-wrapper">
<div class="page-content">
<div class="container-fluid">

<div class="row justify-content-center">
<div class="col-lg-4 col-md-6">

<div class="card bill-card">
<div class="card-body">

<a href="javascript:history.back()" class="btn btn-light w-100 mb-3">
← Go Back
</a>

<div class="bill-title mb-3">
Electric Bill PDF – Bihar
</div>

<form method="POST" id="electricForm">

<div class="mb-3">
<label class="fw-semibold">Enter CA Number</label>
<input type="text"
       name="caNumber"
       class="form-control"
       placeholder="Enter 9 or 12 Digit CA Number"
       required>
</div>

<div class="mb-3">
<input class="form-control fw-bold text-center"
       value="Fee ₹ <?php echo $fee; ?>" readonly>
</div>

<button type="submit"
        id="submitBtn"
        class="bill-btn w-100">
Generate PDF
</button>

</form>

</div>
</div>

</div>
</div>

</div>
</div>
</div>
</div>

<?php include('../template/tngweb/footer.php'); ?>

<!-- ===============================
     CONFIRM + DOUBLE SUBMIT SAFE
================================ -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
document.addEventListener("DOMContentLoaded", function () {

let submitting = false;
const form = document.getElementById("electricForm");
const btn  = document.getElementById("submitBtn");

form.addEventListener("submit", function(e){
  e.preventDefault();
  if (submitting) return;

  Swal.fire({
    title:'Are you sure?',
    text:'Electric Bill PDF generate hogi aur wallet se fee deduct hogi',
    icon:'warning',
    showCancelButton:true,
    confirmButtonText:'Yes, Proceed',
    cancelButtonText:'Cancel'
  }).then((r)=>{
    if(r.isConfirmed){
      submitting = true;
      btn.disabled = true;
      btn.innerText = 'Processing...';
      form.submit();
    }
  });
});

});
</script>

<script src="../template/tngweb/assets/js/bootstrap.bundle.min.js"></script>
<script src="../template/tngweb/assets/plugins/simplebar/js/simplebar.min.js"></script>
<script src="../template/tngweb/assets/plugins/metismenu/js/metisMenu.min.js"></script>
<script src="../template/tngweb/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
<script src="../template/tngweb/assets/js/app.js"></script>
</html>
