<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/tngweb/header.php');

$fee = $udata['dbtAgriculture_br_pdf_a'];
checkServiceStatus($udata, 'dbtAgriculture_br_pdf_a_status');

$appliedby = $udata['phone'];
$balance   = $udata['balance'];


if (!empty($_POST['inputNumber'])) {

    $inputNumber = trim($_POST['inputNumber']);
    $debit_fee   = $balance - $fee;

    if ($balance < $fee) {
        echo "<script src='https://cdn.jsdelivr.net/npm/sweetalert2@11'></script>
        <script>
            Swal.fire('Low Balance','Please Recharge Wallet','error');
            setTimeout(()=>{ window.location='wallet.php'; },1500);
        </script>";
        exit;
    }

    $request = [
        'inputNumber' => $inputNumber
    ];

    $resdata = dbtAgriculture_br_pdf_verification_api_run($request);


    if (!empty($resdata['error'])) {
        echo "<script src='https://cdn.jsdelivr.net/npm/sweetalert2@11'></script>
        <script>
            Swal.fire('Error','".htmlspecialchars($resdata['error'])."','error');
        </script>";
    }

   
    elseif (($resdata['sampleCode'] ?? '') === "200") {

        date_default_timezone_set('Asia/Kolkata');
        $timestamp   = date("Y-m-d H:i:s");
        $parentPhone = $udata['parent'] ?? null;

      
        addCommission(
            $tng_conn,
            $appliedby,
            $fee,
            $parentPhone,
            'DBT Farmer PDF Bihar'
        );

        
        mysqli_query(
            $tng_conn,
            "UPDATE users SET balance = balance - $fee WHERE phone='$appliedby'"
        );

    
        mysqli_query(
            $tng_conn,
            "INSERT INTO wallethistory
            (userid,amount,balance,purpose,status,type)
            VALUES
            (
                '$appliedby',
                '$fee',
                '$debit_fee',
                'DBT Farmer PDF Bihar',
                '1',
                'Debit'
            )"
        );

     
        mysqli_query(
            $tng_conn,
            "INSERT INTO all_pdf_records
            (service_name,name,username,number,pdf,date)
            VALUES
            (
                'dbt_agriculture_bihar_pdf',
                '".mysqli_real_escape_string($tng_conn,($resdata['fullname'] ?? ''))."',
                '$appliedby',
                '".mysqli_real_escape_string($tng_conn,($resdata['regNumber'] ?? $inputNumber))."',
                '".mysqli_real_escape_string($tng_conn,$resdata['pdf'])."',
                '$timestamp'
            )"
        );

     
        echo "<script src='https://cdn.jsdelivr.net/npm/sweetalert2@11'></script>
        <script>
        Swal.fire({
            icon:'success',
            title:'Success',
            text:'DBT Agriculture PDF Generated Successfully',
            timer:1500,
            showConfirmButton:false
        }).then(()=>{
            window.location='all_history.php';
        });
        </script>";
    }
}
?>

<!-- ===============================
     LUXURY UI
================================ -->
<style>
.dbt-card{
    border-radius:18px;
    box-shadow:0 18px 45px rgba(0,0,0,.25);
    background:linear-gradient(135deg,#ffffff,#f0f6ff);
}
.dbt-title{
    background:linear-gradient(90deg,#154360,#1f618d,#2980b9);
    color:#fff;
    padding:14px;
    border-radius:14px;
    text-align:center;
    font-weight:600;
}
.dbt-btn{
    background:linear-gradient(45deg,#154360,#1f618d,#2980b9);
    border:none;
    border-radius:50px;
    padding:12px;
    color:#fff;
    font-weight:600;
}
.dbt-btn:hover{ transform:scale(1.05); }
</style>

<div class="content-wrap">
<div class="main">
<div class="page-wrapper">
<div class="page-content">
<div class="container-fluid">

<div class="row justify-content-center">
<div class="col-lg-4 col-md-6">

<div class="card dbt-card">
<div class="card-body">

<a href="javascript:history.back()" class="btn btn-light w-100 mb-3">
← Go Back
</a>

<div class="dbt-title mb-3">
DBT Agriculture PDF – Bihar
</div>

<form method="POST" id="dbtForm">

<div class="mb-3">
<label class="fw-semibold">
Mobile / Aadhaar / Registration Number
</label>
<input type="text"
       name="inputNumber"
       class="form-control"
       placeholder="Enter Mobile / Aadhaar / Registration No"
       required>
</div>

<div class="mb-3">
<input class="form-control fw-bold text-center"
       value="Fee ₹ <?php echo $fee; ?>" readonly>
</div>

<button type="submit"
        id="submitBtn"
        class="dbt-btn w-100">
Generate PDF
</button>

</form>

</div>
</div>

</div>
</div>

</div>
</div>
</div>
</div>

<?php include('../template/tngweb/footer.php'); ?>

<!-- ===============================
     CONFIRM + DOUBLE SUBMIT SAFE
================================ -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
document.addEventListener("DOMContentLoaded", function () {

let submitting = false;
const form = document.getElementById("dbtForm");
const btn  = document.getElementById("submitBtn");

form.addEventListener("submit", function(e){
  e.preventDefault();
  if (submitting) return;

  Swal.fire({
    title:'Are you sure?',
    text:'DBT Farmer PDF generate hogi aur wallet se fee deduct hogi',
    icon:'warning',
    showCancelButton:true,
    confirmButtonText:'Yes, Proceed',
    cancelButtonText:'Cancel'
  }).then((r)=>{
    if(r.isConfirmed){
      submitting = true;
      btn.disabled = true;
      btn.innerText = 'Processing...';
      form.submit();
    }
  });
});

});
</script>

<script src="../template/tngweb/assets/js/bootstrap.bundle.min.js"></script>
<script src="../template/tngweb/assets/plugins/simplebar/js/simplebar.min.js"></script>
<script src="../template/tngweb/assets/plugins/metismenu/js/metisMenu.min.js"></script>
<script src="../template/tngweb/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
<script src="../template/tngweb/assets/js/app.js"></script>
</html>
