<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/tngweb/header.php');

$fee = $udata['ration_pdf_fee'];
checkServiceStatus($udata, 'ration_pdf_fee_status');

$appliedby = $udata['phone'];
$balance   = $udata['balance'];


if (isset($_POST['ration_no'], $_POST['rationtype'])) {

    $ration_no   = trim($_POST['ration_no']);
    $rationtype  = trim($_POST['rationtype']);
    $debit_fee   = $balance - $fee;

    if ($balance < $fee) {
        echo "<script src='https://cdn.jsdelivr.net/npm/sweetalert2@11'></script>
        <script>
            Swal.fire('Low Balance','Please Recharge Wallet','error');
            setTimeout(()=>{ window.location='wallet.php'; },1500);
        </script>";
        exit;
    }


    $request = [
        'ration_no'  => $ration_no,
        'rationtype' => $rationtype
    ];

    $resdata = ration_pdf_verification_v1_run($request);

    if (($resdata['sampleCode'] ?? '') !== '200') {
        echo "<script src='https://cdn.jsdelivr.net/npm/sweetalert2@11'></script>
        <script>
            Swal.fire(
                'Error',
                '".($resdata['error'] ?? 'Service Error')."',
                'error'
            );
        </script>";
    }
    else {

        date_default_timezone_set('Asia/Kolkata');
        $timestamp   = date("Y-m-d H:i:s");
        $parentPhone = $udata['parent'] ?? null;


        addCommission(
            $tng_conn,
            $appliedby,
            $fee,
            $parentPhone,
            "Ration PDF"
        );


        mysqli_query(
            $tng_conn,
            "UPDATE users SET balance = balance - $fee WHERE phone='$appliedby'"
        );

   
        mysqli_query(
            $tng_conn,
            "INSERT INTO wallethistory
            (userid,amount,balance,purpose,status,type)
            VALUES
            (
                '$appliedby',
                '$fee',
                '$debit_fee',
                'Ration PDF',
                '1',
                'Debit'
            )"
        );


        mysqli_query(
            $tng_conn,
            "INSERT INTO all_pdf_records
            (service_name,name,username,number,pdf,date)
            VALUES
            (
                'ration_pdf',
                '".mysqli_real_escape_string($tng_conn,$resdata['name'])."',
                '$appliedby',
                '".mysqli_real_escape_string($tng_conn,$resdata['ration_no'])."',
                '".mysqli_real_escape_string($tng_conn,$resdata['Ration_Pdf'])."',
                '$timestamp'
            )"
        );


        echo "<script src='https://cdn.jsdelivr.net/npm/sweetalert2@11'></script>
        <script>
        Swal.fire({
            icon:'success',
            title:'Success',
            text:'Ration PDF Generated Successfully',
            timer:1500,
            showConfirmButton:false
        }).then(()=>{
            window.location='all_history.php';
        });
        </script>";
    }
}
?>

<!-- ===============================
     LUXURY UI
================================ -->
<style>
.lux-card{
    border-radius:18px;
    box-shadow:0 18px 45px rgba(0,0,0,.3);
    background:linear-gradient(135deg,#ffffff,#f4f7ff);
}
.lux-title{
    background:linear-gradient(90deg,#141E30,#243B55);
    color:#fff;
    padding:12px;
    border-radius:12px;
    text-align:center;
    font-weight:600;
}
.lux-btn{
    background:linear-gradient(45deg,#0f2027,#203a43,#2c5364);
    border:none;
    border-radius:50px;
    padding:12px;
    color:#fff;
    font-weight:600;
    transition:.3s;
}
.lux-btn:hover{
    transform:scale(1.05);
}
</style>

<div class="content-wrap">
<div class="main">
<div class="page-wrapper">
<div class="page-content">
<div class="container-fluid">

<div class="row justify-content-center">
<div class="col-lg-4 col-md-6">

<div class="card lux-card">
<div class="card-body">

<a href="javascript:history.back()" class="btn btn-light mb-3 w-100">
← Go Back
</a>

<div class="lux-title mb-3">
Ration PDF Verification
</div>

<form method="POST" id="rationForm">

<div class="mb-3">
<label class="fw-semibold">Enter Ration Number</label>
<input type="text" name="ration_no" class="form-control"
       placeholder="Ration Card Number" required>
</div>

<div class="mb-3">
<label class="fw-semibold">Select Ration Type</label>
<select name="rationtype" class="form-control" required>
    <option value="">Select Type</option>
    <option value="new">Mera Ration 2.0</option>
    <option value="old">Old Format</option>
</select>
</div>

<div class="mb-3">
<input class="form-control text-center fw-bold"
       value="Fee ₹ <?php echo $fee; ?>" readonly>
</div>

<button type="submit" id="submitBtn" class="lux-btn w-100">
Generate PDF
</button>

</form>

</div>
</div>

</div>
</div>

</div>
</div>
</div>
</div>

<?php include('../template/tngweb/footer.php'); ?>

<!-- ===============================
     CONFIRM + DOUBLE SUBMIT SAFE
================================ -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
document.addEventListener("DOMContentLoaded", function () {

  let submitting = false;
  const form = document.getElementById("rationForm");
  const btn  = document.getElementById("submitBtn");

  form.addEventListener("submit", function(e){
    e.preventDefault();
    if (submitting) return;

    Swal.fire({
      title: 'Are you sure?',
      text: 'PDF generate hogi aur wallet se fee deduct hogi',
      icon: 'warning',
      showCancelButton: true,
      confirmButtonText: 'Yes, Proceed',
      cancelButtonText: 'Cancel'
    }).then((result)=>{
      if(result.isConfirmed){
        submitting = true;
        btn.disabled = true;
        btn.innerText = 'Processing...';
        form.submit();
      }
    });
  });

});
</script>

<script src="../template/tngweb/assets/js/bootstrap.bundle.min.js"></script>
<script src="../template/tngweb/assets/plugins/simplebar/js/simplebar.min.js"></script>
<script src="../template/tngweb/assets/plugins/metismenu/js/metisMenu.min.js"></script>
<script src="../template/tngweb/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
<script src="../template/tngweb/assets/js/app.js"></script>
</html>
