<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/tngweb/header.php');

$fee = $udata['tng_pan_panfind'];
checkServiceStatus($udata, 'tng_pan_panfind_status');

$tngcharge = [
    'server_1' => $fee,
    'server_2' => $fee + 5,
];

$appliedby = $udata['phone'];
$wallet    = $udata['balance'];

if (!empty($_POST['aadhar']) && !empty($_POST['type'])) {

    $aadhar = trim($_POST['aadhar']);
    $type   = $_POST['type'];
    $fee    = $tngcharge[$type] ?? $fee;

    if ($wallet < $fee) {
        echo "<script src='https://cdn.jsdelivr.net/npm/sweetalert2@11'></script>
        <script>
            Swal.fire({
                icon:'error',
                title:'Wallet Balance Low',
                text:'Please recharge your wallet'
            }).then(()=>{ window.location='wallet.php';});
        </script>";
        exit;
    }

    // ===== API CALL =====
    $request = [
        'aadhar' => $aadhar,
        'type'   => $type,
    ];

    $resdata = pan_find_verificationapi_run($request);

    if (!isset($resdata['sampleCode'])) {
        echo "<script>Swal.fire('Error','Invalid API response','error');</script>";
        exit;
    }

    if ($resdata['sampleCode'] === "200" || $resdata['sampleCode'] === "208") {

        // ===== WALLET + COMMISSION =====
        $parentPhone = $udata['parent'] ?? null;
        addCommission(
            $tng_conn,
            $appliedby,
            $fee,
            $parentPhone,
            "Aadhar To PAN Find"
        );

        mysqli_query($tng_conn,
            "UPDATE users SET balance = balance - $fee WHERE phone='$appliedby'"
        );

        mysqli_query($tng_conn,
            "INSERT INTO wallethistory
            (userid, amount, balance, purpose, status, type)
            VALUES
            ('$appliedby','$fee','".($wallet-$fee)."','Aadhar To PAN Find','1','Debit')"
        );

        // ===== JSON STORE (BASE64) =====
        $jsonEncoded = base64_encode(json_encode($resdata));

        mysqli_query($tng_conn,
            "INSERT INTO all_pdf_records
            (service_name, name, username, number, pdf, date)
            VALUES (
              'aadhar_to_pan_find',
              '".mysqli_real_escape_string($tng_conn, $resdata['pan'] ?? 'NA')."',
              '$appliedby',
              '".mysqli_real_escape_string($tng_conn, $aadhar)."',
              '".mysqli_real_escape_string($tng_conn, $jsonEncoded)."',
              NOW()
            )"
        );

        echo "<script src='https://cdn.jsdelivr.net/npm/sweetalert2@11'></script>
        <script>
            Swal.fire({
                icon:'success',
                title:'Success',
                text:'PAN Find completed successfully'
            }).then(()=>{
                window.location='all_history.php';
            });
        </script>";
        exit;

    } else {

        echo "<script src='https://cdn.jsdelivr.net/npm/sweetalert2@11'></script>
        <script>
            Swal.fire({
                icon:'error',
                title:'Failed',
                text:'".addslashes($resdata['message'] ?? 'Request failed')."'
            });
        </script>";
        exit;
    }
}
?>


<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<div class="content-wrap">
 <div class="main">
<div class="page-wrapper">
    <div class="page-content">
        <div class="mobile-menu-overlay"></div>
        <div class="main-container">
            <div class="col-lg-12">
                <div class="card" style="margin-left: 10px; padding-left: 30px; padding-top: 12px; box-shadow: 1px 5px 5px 5px;">
                    <div class="stat-widget-two">
                        <div class="stat-content">
                            <div class="stat-text">
                                <div class="container-fluid">
                                    <div class="row">
                                        <div class="col-lg-4 col-md-6 col-sm-6">
                                            <div class="card">
                                                <div class="card-body">
                                                    <div class="mb-4">
        <a href="javascript:history.back()" class="back-btn">
            <i class="bi bi-arrow-left-circle"></i> Go Back
        </a>
    </div>
                                                    <div class="alert alert-info" role="alert">
                                                         Aadhar To Pan Verification
                                                    </div>
                                                    <form action="" method="POST" class="row g-3">
                                                        <div class="card-body">
                                                            <div class="col-md-12">
                                                                <div class="form-group">
                                                                    <label for="aadhar">Enter Aadhar Number</label>
                                                                    <input name="aadhar" type="text" id="aadhar" placeholder="Enter Aadhar Number" class="form-control" required>
                                                                </div>
                                                                
                                                                <div class="form-group mt-2">
                                                                    <label for="type">Select Server Type</label>
                                                                   <select name="type" id="serverType" class="form-control" required>
                                                                       <option value="">Select Server Type</option>
                                                                       <option value="server_1">Server 1</option>
                                                                       <option value="server_2">Server 2</option>
                                                                   </select>
                                                                </div>
                                                                <hr>
                                                                <div class="row mt-3">
                                                                  <div class="col-md-6">
                                                                      <input id="feeDisplay" class="form-control" value="Fee ₹ -" readonly>
                                                                   </div>
                                                                   <div class="col-md-6 text-end">
                                                                       <button class="btn btn-primary" name="submit" id="submit"><i class="fa fa-check-circle"></i> Submit</button>
                                                                   </div>
                                                               </div>
                                                            </div>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>

                                       <?php if (!empty($resdata) && $resdata['sampleCode'] === "200" || $resdata['sampleCode'] === "208") { 
                                            $aadhar_display = htmlspecialchars($resdata['aadhar'] ?? '');
                                            $pan_display = htmlspecialchars($resdata['pan'] ?? '');
                                            $message_display = htmlspecialchars($resdata['message'] ?? '');
                                        ?>
                                        <div class="col-lg-8 col-md-6 col-sm-6">
                                            <div class="card" style="background-color: #E8F6F3;">
                                                <div class="card-body">
                                                    <div id="capture-area" style="padding: 10px; background: white; color: black;">
                                                      
                                                        <h5>
  Aadhar To Pan Find 
  <a href="Pan_find_list.php" style="font-size:14px; margin-left:10px; text-decoration:none; color:blue;">
    (View List)
  </a>
</h5>

                                                        <table class="table table-bordered table-striped">
                                                            <tbody>
                                                                <tr><th>Aadhar Number</th><td><?php echo $aadhar_display; ?></td></tr>
                                                                <tr><th>Pan Number</th><td><?php echo $pan_display; ?></td></tr>
                                                                <tr><th>Message</th><td><?php echo $message_display; ?></td></tr>
                                                            </tbody>
                                                        </table>
<p style="margin-top: 20px; font-weight: bold; text-align: center;">
    Developed by <?php echo XyZ_val('baseurl'); ?>
</p>


                    

                                                        <div class="text-center">
                                                            <button id="downloadBtn" class="btn btn-success mt-3">Download PNG</button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <script>
                                            const aadharNumber = "<?php echo $aadhar_display; ?>";
                                            const panNumber = "<?php echo $pan_display; ?>";
                                        </script>
                                        <?php } ?>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
<script>
    document.getElementById("downloadBtn")?.addEventListener("click", function () {
        const element = document.getElementById("capture-area");
        html2canvas(element).then(canvas => {
            const image = canvas.toDataURL("image/png");
            const link = document.createElement("a");
            link.href = image;
            link.download = "aadhar_to_pan_" + aadharNumber + "_" + panNumber + ".png";
            link.click();
        });
    });
</script>

<script>
    const charges = <?php echo json_encode($tngcharge); ?>;
    document.getElementById('serverType').addEventListener('change', function () {
        const selected = this.value;
        const fee = charges[selected] ?? '-';
        document.getElementById('feeDisplay').value = "Fee ₹ " + fee;
    });
</script>
<script>
document.addEventListener("DOMContentLoaded", function () {
    const form = document.querySelector("form");
    const submitBtn = document.getElementById("submit");

    let isSubmitting = false;

    form.addEventListener("submit", function (e) {
        if (isSubmitting) {
            e.preventDefault();
            return;
        }
        isSubmitting = true;       
        submitBtn.disabled = true; 
    });
});
</script>
	<?php 
		include('../template/tngweb/footer.php');
		?>
	<!-- Bootstrap JS -->
	

	<script src="../template/tngweb/assets/js/bootstrap.bundle.min.js"></script>
	<!--plugins-->
	<!-- <script src="../template/tngweb/assets/js/jquery.min.js"></script> -->
	<script src="../template/tngweb/assets/plugins/simplebar/js/simplebar.min.js"></script>
	<script src="../template/tngweb/assets/plugins/metismenu/js/metisMenu.min.js"></script>
	<script src="../template/tngweb/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
	<!--app JS-->
	<script src="../template/tngweb/assets/js/app.js"></script>
</body>
